﻿//collateralUtilityFunctions.js
var _minSafeInteger = Number.MIN_SAFE_INTEGER;
var _maxSafeInteger = Number.MAX_SAFE_INTEGER;
var _onDataTableColumnSorted = "order.dt";
var _tagCharLimit = {};
var string = String;
var _regexEIN = /^\d{2}-?\d{7}$/;
var _regexSSN = /^\d{3}-?\d{2}-?\d{4}$/;
var regexEmail = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
var _datatableDomDateSet;
$.register = function (obj, functionName, fn, force) {
	if (force === true || !isFunction(obj[functionName])) {
		obj[functionName] = fn;
	}
};
$.fnRegister = function (obj, functionName, fn, force) {
	if (force === true || !isFunction(obj[functionName])) {
		obj.fn[functionName] = fn;
	}
};
String.prototype.replaceAt = function (index, character) {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().substr(0, index) + character + this.toString().substr(index + character.length);
};
//var _eventList = ["input[type='text']", "keyup", "mouseup", "drop", "paste"];//"keydown","mousedown","contextmenu",
var _eventList = ["keyup", "mouseup", "drop", "paste"];//"keydown","mousedown","contextmenu",

var _extendedASCIIcharactersMessage = "Extended ASCII characters <br/>in your copy/paste are prohibited";
//ASCII control characters (character code 0-31): The first 32 characters in the ASCII-table are unprintable control codes and are used to control peripherals such as printers.
var _extendedASCII_0_To_31 = [];
for (var asciiCode = 0; asciiCode <= 31; asciiCode++) {
	_extendedASCII_0_To_31.push(asciiCode);
}
//ASCII printable characters (character code 32-127)
//Codes 32-127 are common for all the different variations of the ASCII table, they are called printable characters, represent letters, digits, punctuation marks, and a few miscellaneous symbols.
//You will find almost every character on your keyboard.Character 127 represents the command DEL.
var _extendedASCII_32_To_127 = [];
for (var asciiCode = 32; asciiCode <= 127; asciiCode++) {
	_extendedASCII_32_To_127.push(asciiCode);
}
//The extended ASCII codes(character code 128 - 255)
//There are several different variations of the 8 - bit ASCII table.The table below is according to Windows - 1252(CP - 1252) which is a superset of ISO 8859 - 1, also called ISO Latin - 1,
//in terms of printable characters, but differs from the IANA's ISO-8859-1 by using displayable characters rather than control characters in the 128 to 159 range. Characters that differ from ISO-8859-1 is marked by light blue color.
var _extendedASCII_128_To_255 = [];
for (var asciiCode = 128; asciiCode <= 255; asciiCode++) {
	_extendedASCII_128_To_255.push(asciiCode);
}

var _keyCodes = {};
const jsRandom36 = () => { return Math.random().toString(36).substr(2); };
const jsToken = () => { return jsRandom36() + jsRandom36(); };
Object.defineProperty(_keyCodes, "backspace", { value: 8, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "tab", { value: 9, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "enter", { value: 13, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadEnter", { value: 13, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "controlLeft", { value: 17, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "controlRight", { value: 17, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "space", { value: 32, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "end", { value: 35, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "home", { value: 36, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "arrowLeft", { value: 37, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "arrowUp", { value: 38, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "arrowRight", { value: 39, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "arrowDown", { value: 40, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "delete", { value: 46, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "minus", { value: 189, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "period", { value: 190, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d0", { value: 48, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d1", { value: 49, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d2", { value: 50, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d3", { value: 51, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d4", { value: 52, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d5", { value: 53, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d6", { value: 54, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d7", { value: 55, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d8", { value: 56, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "d9", { value: 57, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad0", { value: 96, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad1", { value: 97, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad2", { value: 98, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad3", { value: 99, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad4", { value: 100, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad5", { value: 101, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad6", { value: 102, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad7", { value: 103, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad8", { value: 104, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPad9", { value: 105, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadMultiply", { value: 105, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadAdd", { value: 107, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadSubtract", { value: 109, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadDecimal", { value: 110, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "numPadDivide", { value: 111, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "F5", { value: 116, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "equal", { value: 187, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "lessThan", { value: 188, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "greaterThan", { value: 190, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "decimal", { value: 110, writable: false, enumerable: true, configurable: true });
Object.defineProperty(_keyCodes, "previousCode", { value: null, writable: true, enumerable: false });
//
Object.defineProperty(string, "empty", { value: "", writable: false });
Number.prototype.formatMoney = function (c, d, t) {
	var n = this,
		c = isNaN(c = Math.abs(c)) ? 2 : c,
		d = d == undefined ? "." : d,
		t = t == undefined ? "," : t,
		s = n < 0 ? "(" : "",
		l = n < 0 ? ")" : "",
		i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "",
		j = (j = i.length) > 3 ? j % 3 : 0;

	return s + '$' + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "") + l;
};
function showDialog(dialogId) {
	if (typeof dialogId == "undefined") { dialogId = "divProcessing"; }
	$("#" + dialogId).modal('show');
	$('.modal-backdrop').remove();
}
function hideDialog(dialogId) {
	if (typeof dialogId == "undefined") { dialogId = "divProcessing"; }
	$("#" + dialogId).modal('hide');
}
function getComboBoxOptionsByTypes(cboId, comboBoxOptions) {
	/// <summary>
	/// Gets the ComboBox options by types.
	/// </summary>
	/// <param name="cboId">The cbo identifier.</param>
	/// <param name="comboBoxOptions">The combo box options.</param>
	/// <returns></returns>

	var jsonText = $.toJSON({ cboId: cboId, transactionId: $("#" + window.dm_ViewId).val() });
	var serviceUrl = "../../WebServices/DataAccessServiceJson.asmx/GetComboList";
	return ajaxSubmit(serviceUrl, jsonText, function (msg) {
		msg = JSON.parse(msg.d);
		if (msg.Success !== true) {
			ShowError(msg.Result);

			return;
		}

		$.merge(comboBoxOptions, msg.Data.ResultSet);
		$("#" + window.dm_ViewId).val(msg.TransactionId);
	});
}
function getWebRoles(partyType, webRoles) {
	/// <summary>
	/// Gets the web roles.
	/// </summary>
	/// <param name="partyType">Type of the party.</param>
	/// <param name="webRoles">The web roles.</param>
	/// <returns></returns>

	var jsonText = $.toJSON({ partyType: partyType, transactionId: $("#" + window.dm_ViewId).val() });
	var serviceUrl = "../../WebServices/DataAccessServiceJson.asmx/GetAllWebRoles";
	return ajaxSubmit(serviceUrl, jsonText, function (msg) {
		msg = JSON.parse(msg.d);
		if (msg.Success !== true) {
			ShowError(msg.Result);

			return;
		}
		$.merge(webRoles, []);
		$.merge(webRoles, msg.Data.ResultSet);
		$("#" + window.dm_ViewId).val(msg.TransactionId);
	});
}
function getStates(stateArray) {
	/// <summary>
	/// Gets the states.
	/// </summary>
	/// <param name="stateArray">The state array.</param>
	/// <returns></returns>
	var jsonText = $.toJSON({ transactionId: $("#" + window.dm_ViewId).val() });
	var serviceUrl = "../../WebServices/DataAccessServiceJson.asmx/GetStates";
	return ajaxSubmit(serviceUrl, jsonText, function (msg) {
		msg = JSON.parse(msg.d);
		if (msg.Success !== true) {
			ShowError(msg.Result);

			return;
		}

		if (typeof stateArray != "undefined") {
			$.merge(stateArray, []);
			$.merge(stateArray, JSON.parse(msg.Data).ResultSet);
		} else {
			states = JSON.parse(msg.Data).ResultSet;
		}

		$("#" + window.dm_ViewId).val(msg.TransactionId);
	});
}
function getTimeZones(timeZoneArray) {
	/// <summary>
	/// Gets the time zones.
	/// </summary>
	/// <param name="timeZoneArray">The time zone array.</param>
	/// <returns></returns>
	var jsonText = $.toJSON({ transactionId: $("#" + window.dm_ViewId).val() });
	var serviceUrl = "../../WebServices/DataAccessServiceJson.asmx/TimeZonesSelectAll";
	return ajaxSubmit(serviceUrl, jsonText, function (msg) {
		msg = JSON.parse(msg.d);
		if (msg.Success !== true) {
			ShowError(msg.Result);

			return;
		}

		$.merge(timeZoneArray, []);
		$.merge(timeZoneArray, msg.Data.ResultSet);

		$("#" + window.dm_ViewId).val(msg.TransactionId);
	});
}
function setPageTabState(tabName) {
	/// <summary>
	/// Sets the state of the page tab.
	/// Creates a universal method to restore tabs and there perspective states upon form submit and redirect back to the page.
	/// </summary>
	/// <param name="tabName">Name of the tab.</param>
	/// <returns></returns>
	var tabStateFunctions = {};
	$("#tabState").val() == "" ? tabStateFunctions = {} : tabStateFunctions = JSON.parse($("#" + $$("tabState").attr("id")).val().replace(/'/g, '"'));

	tabStateFunctions["MainTab"] = tabName;
	$("#tabState").val(JSON.stringify(tabStateFunctions));
}
function setTabDocumentType(mainTabDocumentType) {
	/// <summary>
	/// Sets the type of the tab document.
	/// Creates a universal method to restore tabs and there perspective states upon form submit and redirect back to the page.
	/// </summary>
	/// <param name="mainTabDocumentType">Type of the main tab document.</param>
	/// <param name="contactDocumentType">Type of the contact document.</param>
	/// <returns></returns>
	var tabStateFunctions = {};
	$("#tabState").val() == "" ? tabStateFunctions = {} : tabStateFunctions = JSON.parse($("#" + $$("tabState").attr("id")).val().replace(/'/g, '"'));
	if ($("#" + mainTabDocumentType).hasClass("tree-opened")) {
		tabStateFunctions["CurrentlySelectedDocumentTypeType"] = mainTabDocumentType;
	}
	$("#tabState").val(JSON.stringify(tabStateFunctions));
}
function restoreTreeToOpenPosition(treeId) {
	/// <summary>
	/// Restores the tree to open position.
	/// This only works for single level tree.  If there are multiple levels this will need to be called for deach level in order.
	/// </summary>
	/// <param name="treeId">The tree identifier.</param>
	/// <returns></returns>
	$("#" + treeId).removeClass("tree-closed");
	$("#" + treeId).addClass("tree-opened .active");
	$("#" + treeId + " > ul").show();
}
function restoreDocumentTypeTreeState() {
	var tabStateFunctions = {};

	$("#tabState").val() == "" ? tabStateFunctions = {} : tabStateFunctions = JSON.parse($("#" + $$("tabState").attr("id")).val().replace(/'/g, '"'));
	var documentTypeTree = tabStateFunctions.CurrentlySelectedDocumentTypeType;

	restoreTreeToOpenPosition(documentTypeTree);
}
function toggleSection(selector) {
	$(selector).trigger("click");
}
function toggleDisabled(selector) {
	$(selector).attr("disabled", function (_, attr) { return !attr; });
}
function toggleElementVisibility(selector, visible) {
	if (visible) {
		$(selector).show();
	} else {
		$(selector).hide();
	}
}
function isFunction(callback) {
	return exists(callback) && typeof callback === "function";
}
function isNumeric(value) {
	value = exists(value) ? (value).toString() : "";
	return !isNullOrWhiteSpace(value) && !isNaN(new Number(value));
}
function isInt(value) {
	return isNumeric(value);
}
function isDecimal(value) {
	return isNumeric(value) && value.includes(".");
}
function isValidNumeric(element, evt) {
	var charCode = (evt.which) ? evt.which : evt.keyCode;
	return (charCode > 47 && charCode < 58);
}
function isValidDecimal(element, evt) {
	var charCode = (evt.which) ? evt.which : evt.keyCode;
	var isPeriod = charCode === 46;
	var hasPeriod = $(element).val().indexOf(".") > -1;
	var isDigit = isValidNumeric(element, evt);
	return !hasPeriod && isDigit || !hasPeriod && isPeriod || hasPeriod && isDigit || hasPeriod && isDigit && !isPeriod;
}
function isValidDateFormat(stringValue, format) {
	if (!format) {
		format = "MM/DD/YYYY HH:mm:ss";
	}
	return moment(stringOrDefault(stringValue), format, true).isValid();
}
function validateNumeric(element, evt) {
	var isNumber = isValidNumeric(element, evt);
	if (!isNumber) {
		try {
			evt.preventDefault();
			return false;
		} catch (e) {
			//window.event.preventDefault();
			return false;
		}
	}
	return true;
}
function validateDecimal(element, evt) {
	var isDecimal = isValidDecimal(element, evt);
	if (!isDecimal) {
		evt.preventDefault();
		return false;
	}
	return true;
}
function validateDecimalPlaces(input, place, evt) {
	var charCode = (evt.which) ? evt.which : evt.keyCode;
	var isPeriod = charCode === 46;
	let value = input.value;
	let array = value.split(".");
	var isDigit = isValidNumeric(input, evt);
	if (!isDigit && value.firstChar(1) === "." || (isNullOrWhiteSpace(value) && isPeriod)) {
		value = string.format("0.{0}", value.remove("."));
		input.value = value;
	}
	if (array.length > 1) {
		var last = array[1];
		if (last.length > place) {
			last = last.first(place);
		}
		value = string.format("{0}.{1}", array[0], last);
		input.value = value;
	}
	let lastNchars = value.lastChar(place);
	var periodIndex = value.indexOf(".");
	var hasPeriod = periodIndex > -1;
	if ((hasPeriod && isPeriod) || (hasPeriod && !isDigit) || (!hasPeriod && !isPeriod && !isDigit)) {
		evt.preventDefault();
		return false;
	}
	if (isDigit && hasPeriod && !lastNchars.includes(".")) {//&& value.length > periodIndex 
		var regex = new RegExp("^\d+\.(\d{1," + place + "})?$");
		if (!regex.test(value)) {
			evt.preventDefault();
			return false;
		}
	}
	return true;
}
function setCharacterLimitation() {
	Object.defineProperty(_tagCharLimit, "max0", { value: 0, writable: false });
	Object.defineProperty(_tagCharLimit, "max10", { value: 10, writable: false });
	Object.defineProperty(_tagCharLimit, "max20", { value: 20, writable: false });
	Object.defineProperty(_tagCharLimit, "max32", { value: 32, writable: false });
	Object.defineProperty(_tagCharLimit, "max128", { value: 128, writable: false });
	Object.defineProperty(_tagCharLimit, "max200", { value: 200, writable: false });
	Object.defineProperty(_tagCharLimit, "max255", { value: 255, writable: false });
	Object.defineProperty(_tagCharLimit, "max1000", { value: 1000, writable: false });
	Object.defineProperty(_tagCharLimit, "max4000", { value: 4000, writable: false });
}
function registerTextBoxEventWithLimitation(selector, limit) {
	$(selector).on("keypress", function (evt) {
		var self = $(this);
		if (self && self.val().length >= limit) {
			evt.preventDefault();
			self.trigger("blur");
		}
	});
	$(selector).on("paste", function (evt) {
		var self = $(this);
		var clipboardData = "";
		try {
			clipboardData = evt.originalEvent.clipboardData.getData("text");//Chrome
		}
		catch (e) {
			clipboardData = window.clipboardData.getData("text");//IE
		}
		var trimmedClipboardData = clipboardData.trim().substring(0, limit);
		if (self && self.val().length > _tagCharLimit.max0) {
			evt.preventDefault();
		}
		else {
			self.val(trimmedClipboardData);
			evt.preventDefault();
		}
	});
}
function getPageNameFromURL() {
	let pageName = location.href.split("/").lastOrDefault();
	if (isNullOrWhiteSpace(pageName)) return string.empty;
	return pageName.split("?").firstOrDefault().toUpperCase();
}
// DATATABLE
function dataTableHasMultiplePages(dataTableElement) {
	var hasApi = true;
	try {
		hasApi = dataTableElement && exists(dataTableElement.api());
	} catch (e) {
		hasApi = false;
	}
	if (!hasApi) return false;
	return dataTableElement.api().page.info().pages > 1;
}
function updateDataTablePagination(dataTablesElement, shrinkHeight) {
	var pagination = $(dataTablesElement).closest(".dataTables_wrapper").find(".dataTables_paginate");
	if (!pagination) return;
	var hasMultiplePages = dataTableHasMultiplePages(dataTablesElement);
	pagination.toggle(hasMultiplePages);
	var row = pagination.closest(".row");
	if (!hasMultiplePages && row) {
		row.hide();
	}
	if (!hasMultiplePages && row && shrinkHeight) {
		row.parent().find(".dataTables_scrollBody").css("max-height", "");
	}
}
function dataTableRowSelected(dataTableId, parentId) {
	if (!parentId) {
		parentId = dataTableId + "_wrapper";
	}
	// TODO: should handle click event on left side fixed-table (DTFC_LeftBodyWrapper)
	$(string.format("#{0} > tbody > tr", dataTableId)).on("click", function (event) {
		var row = $(this);
		var rowPosition = row.index() + 1;
		var clonedTable = $(string.format("#{0} div.DTFC_LeftBodyWrapper table.DTFC_Cloned > tbody > tr:nth-child({1})", parentId, rowPosition));
		$(string.format("#{0} div.DTFC_LeftBodyWrapper table.DTFC_Cloned > tbody > tr.dataTableSelectedRow", parentId)).removeClass("dataTableSelectedRow");
		var wasSelected = row.hasClass("dataTableSelectedRow");
		row.closest("table.dataTable").find("tbody > tr.dataTableSelectedRow").removeClass("dataTableSelectedRow");
		if (!wasSelected) {
			row.toggleClass("dataTableSelectedRow");
		}
		if (wasSelected) {
			clonedTable.removeClass("dataTableSelectedRow");
		} else {
			clonedTable.addClass("dataTableSelectedRow");
		}
	});
}
function setDataTableHeaderLabels(dataTable, data) {
	$.each(data, (_, obj) => {
		if (obj.index <= 0) return;
		if (exists(obj.width)) {
			$(dataTable.api().column(obj.index).header()).css("width", string.format("{0} !important;", obj.width));
		}
		$(dataTable.api().column(obj.index).header()).text(obj.headerText);
	});
	getDomElementById($(dataTable).attr("id")).dataTable().fnAdjustColumnSizing();
}
function resizeDataTableColumns(selector, timeout) {
	if (isNullOrWhiteSpace(selector)) return;
	if (isNullOrUndefined(timeout)) {
		timeout = 10;
	}
	var element = $(selector);
	if (!exists(element) || !exists(element.dataTable())) return;
	setTimeout(function () {
		element.dataTable().fnAdjustColumnSizing();
	}, timeout);
}
function updateDataTableCellValue(selectorId, rowIndex, columnIndex, data, refresh) {
	var tableElement = getDomElementById(selectorId);
	if (exists(tableElement)) {
		var datatable = tableElement.DataTable();
		var dataObject = datatable.cell({ row: rowIndex, column: columnIndex }).data(data);
		if (refresh) {
			dataObject.draw();
		}
	}
}
function hideDataTableColumn(selectorId, columnIndex) {
	var tableElement = getDomElementById(selectorId);
	if (exists(tableElement)) {
		var datatable = tableElement.DataTable();
		//Once a column is hidden its index become NULL. Then its previous position is occupied by the following column.
		datatable.column(columnIndex).visible(false);
	}
}
function showDataTableColumn(selectorId, columnIndex) {
	var tableElement = getDomElementById(selectorId);
	if (exists(tableElement)) {
		var datatable = tableElement.DataTable();
		// column will regain its original index position
		datatable.column(columnIndex).visible(true);
	}
}
function turnOffAutoComplete(datatable, delay = 100) {
	var $datatableSearchBox = $(datatable.api().table().container()).find('input[type="search"]');
	let $parent = $datatableSearchBox.parent();
	if ($parent && $parent.length > 0 && !$($parent).hasAttr("autocomplete")) {
		$datatableSearchBox.wrap("<form style='display:inline-grid;'>");
	}
	preventAutoComplete();
}
function htmlTableRowSelected(tableId) {
	$(string.format("table#{0} > tbody > tr", tableId)).on("click", function (event) {
		var row = $(this);
		var wasSelected = row.hasClass("dataTableSelectedRow");
		row.closest("table").find("tbody > tr.dataTableSelectedRow").removeClass("dataTableSelectedRow");
		if (!wasSelected) {
			row.toggleClass("dataTableSelectedRow");
		}
	});
}
function isDataTable(tableId) {
	return $.fn.dataTable.isDataTable(string.format("#{0}", tableId));
}
function getDataTableApi(tableId) {
	if (!isDataTable(tableId)) return [];
	return getDomElementById(tableId).dataTable().api();
}
function getDataTableData(tableId) {
	return getDataTableApi(tableId).data().toArray();
}
function getDataTableAppliedData(tableId) {
	return getDataTableApi(tableId).rows({ search: 'applied' }).data().toArray();
}
function getDataTableRemovedData(tableId) {
	return getDataTableApi(tableId).rows({ search: 'removed' }).data().toArray();
}
function resetDataTableSorting(tableId) {
	if (!isDataTable(tableId)) return;
	getDomElementById(tableId).DataTable().order([]).draw();
}
function stringToBoolean(value) {
	if (!value) return false;
	try {
		value = (value).toString().toLowerCase().trim();
	} catch (e) {
		value = null;
	}
	switch (value) {
		case "true": case "yes": case "1": return true;
		case "false": case "no": case "0": case null: return false;
		default: return true;
	}
}
function booleanToYesNoOrDefault(value) {
	if (isNullOrUndefined(value)) return string.empty;
	return stringToBoolean(value) ? "Yes" : "No";
}
function booleanToNullableYesNo(value) {
	if (isNullOrWhiteSpace(value)) return undefined;
	try {
		value = (value).toString().toLowerCase().trim();
	} catch (e) {
		return undefined;
	}
	switch (value) {
		case "true": case "yes": case "1": return "Yes";
		case "false": case "no": case "0": return "No";
		case "-1": return undefined;
		default:
			{
				if (value.intOrDefault() < 0) return undefined;
				return value.length > 0 ? "Yes" : undefined
			}
	}
}
function isBoolean(value) {
	return typeof value === "boolean";
}
// returns true if the value parameter is null or an empty string (""), [or if value consists exclusively of white-space characters (" ")]
// We never checked for the "white-space characters" during implementation. And now we cannot change it as this is used on so many places.
function isNullOrWhiteSpace(value) {
	return isNullOrUndefined(value) || stringOrDefault(value).trim().length === 0;
}
//returns true if the value parameter is null or an empty string (""); otherwise, false.
function isNullOrEmpty(value) {
	return isNullOrUndefined(value) || stringOrDefault(value).trim().length === 0;
}
function isValidEmail(email) {
	return /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email);
}
function firstChar(str, count) {
	if (!count) {
		count = 1;
	}
	if (String.hasContent(str) && str.length > count) {
		return str.substr(0, count);
	}
	return str;
}
function lastChar(str, count) {
	if (!count) {
		count = 1;
	}
	if (String.hasContent(str) && str.length >= count) {
		return str.substr(str.length - count, count);
	}
	return str;
}
function formatPhoneNumber(phoneNumber) {
	return phoneNumber.replace(/\(/g, "").replace(/\)/g, "").replace(/\+/g, "").replace(/^(\d{3}[-\s.]?)(\d{3}[-\s.]?)(\d{4})([\w\s\d]*)$/g, "$1-$2-$3 $4").replace(/--/g, "-").replace(/\s+/g, " ");
}
function isValidUsPhoneNumber(value) {
	//return /^\(?([0-9]{3})\)?[-./ ]?([0-9]{3})[-./ ]?([0-9]{4})[\w\s]*$/.test(value);// if with extension
	return /^\(?([0-9]{3})\)?[-./ ]?([0-9]{3})[-./ ]?([0-9]{4})$/.test(value);
}
function navigateToParentRootWindow(windowCount) {
	var currentWindow = window;
	var previousWindow = window.opener;
	var closedCounter = 0;
	while (previousWindow) {
		if (currentWindow) {
			currentWindow.close();
			closedCounter++;
			currentWindow = previousWindow;
			if (windowCount === closedCounter) {
				break;
			}
			previousWindow = previousWindow.opener;
		}
	}
	return currentWindow;
}
function disableLinks(parentSelector) {
	var linkDisabler = $(parentSelector).find(".linkDisabler");
	if (linkDisabler.length) {
		linkDisabler.show();
	} else {
		var disabler = "<div class='linkDisabler' style='position: absolute;display: flex;align-items: center; top: 0;bottom:0; left: 0;right:0; width: 100%; height: 100%;padding:0;'><div style='display: flex;margin: 0 auto;padding:0;'><i class='fa fa-spinner fa-pulse' style='color:#176BAC;font-size:30px;position:relative;'></i><span style='color:#176BAC;font-size:20px;position:relative;margin-left:4px;'>Please wait...</span></div></div>";
		$(parentSelector).prepend(disabler);
	}
}
function disableLink(selector) {
	getDomElementById(selector).addClass("disabled-link");
}
function enableLinks(parentSelector) {
	var linkDisabler = $(parentSelector).find(".linkDisabler");
	if (linkDisabler.length) {
		linkDisabler.remove();
	}
}
function enableLink(selector) {
	getDomElementById(selector).removeClass("disabled-link");
}
function disableLinkNoBg(selector) {
	getDomElementById(selector).addClass("disabled-link-nbg");
}
function enableLinkNoBg(selector) {
	getDomElementById(selector).removeClass("disabled-link-nbg");
}
function isNullOrUndefined(obj) {
	return obj === undefined || obj === null;
}
function exists(obj) {
	return !isNullOrUndefined(obj);
}
/*
 * Shows a basic ValueNet alert similar to javascript alert()
 *
 * @message {string} The message to display in the alert body.
 * @headerTitle {string} Optional text displayed in header.  Default is 'Alert'.
 */
function commonDialogAlert(message, headerTitle = 'Alert') {
	var data = {
		title: headerTitle,
		showCloseBtn: true,
		//headerColor: "#2591b1",
		showCloseBtnFn: "hideCommonDialog();",
		body: message,
		footer: "<button type='button' class='btn btn-primary btn-flat pull-right bold' style='width: 100px; cursor: pointer;' onclick='hideCommonDialog();'>OK</button>"
	};
	showCommonDialog(data);
}
/*
 * Shows a basic ValueNet alert similar to javascript confirm()
 *
 * @message {string} The message to display in the alert body.
 * @confirmFunctionCall {string} The function that will executed when the confirm button is clicked
 * @headerTitle {string} Optional text displayed in header.  Default is 'Alert'.
 * example commonDialogConfirm('Are you sure you want to delete this photo?', "deleteUADPhoto()")
 */
function commonDialogConfirm(message, confirmFunctionCall, headerTitle = 'Confirm') {
	var cancelBtn = "<button type='button' class='btn btn-danger btn-flat pull-left bold' style='width: 100px;' onclick='hideCommonDialog();'><i class='fa fa-remove'></i> Cancel</button>";
	var confirmBtn = "<button type='button' class='btn btn-primary btn-flat pull-right' causesvalidation='False' style='text-align: center; width: 120px;' onclick='" + confirmFunctionCall + "'><i class='fa fa-check'></i>&nbsp;<span> Yes</span></button>";
	var data = {
		title: headerTitle,
		showCloseBtn: true,
		preventBackgroundScrolling: true,
		headerColor: "#2591b1",
		showCloseBtnFn: "hideCommonDialog()",
		body: message,
		footer: cancelBtn + confirmBtn
	};
	showCommonDialog(data);
}
function showCommonDialog(data) {
	if (!data) return;
	//if (!data.headerColor) {
	//    data.headerColor = "gray";
	//}
	var modal =
		"<div id='commonDialog' class='modal' role='dialog' data-backdrop='static' data-keyboard='false' onkeypress = 'handleKeyDownEvent(event);'>" +
		"<div class='modal-dialog' style='width:" + (isNullOrWhiteSpace(data.modalWidth) ? "600px" : data.modalWidth) + "'><div class='modal-content' style='margin: 60px auto;'>" +
		"<div class='modal-header'>" +
		"<button id='commonHeaderCloseBtn' type='button' class='close' onclick='hideCommonDialog();' data2-dismiss='modal' style='color: white;display: none;'>&times;</button>" +
		"<h4 id='commonDialogTitle' class='modal-title' style='text-align: left;'></h4>" +
		"</div>" +
		"<div class='modal-body' style='font-size: 24px;text-align: left;'>" +
		"<div id='commonDialogSpinner' style='text-align: center; color: gray; display: none; margin-bottom: 20px;'>" +
		"<span class='fa fa-spinner fa-spin'></span>" +
		"<span style='margin-left:5px;'>Please Wait</span>" +
		"<span style='margin-left:5px;font-size:42px;line-height:20px;'>...</span>" +
		"</div>" +
		"<div id='mainmessage' style='font-size: 15px;'></div>" +
		"</div>" +
		"<div id='commonDialogFooter' class='modal-footer' style='text-align: center;'></div>" +
		"</div>" +
		"</div>";
	$("#commonDialogDiv").html(modal);
	if (data.showCloseBtn) { $("#commonHeaderCloseBtn").show(); }
	if (data.showCloseBtn && data.showCloseBtnFn) { $("#commonHeaderCloseBtn").attr("onclick", data.showCloseBtnFn); }
	if (data.title) { $("#commonDialogTitle").html(data.title); }
	if (data.showSpinner) { $("#commonDialogSpinner").show(); }
	if (data.body) { $("#mainmessage").html(data.body); } else { $("#mainmessage").hide(); }
	if (data.footer) { $("#commonDialogFooter").html(data.footer); } else { $("#commonDialogFooter").hide(); }
	$("#commonDialog").show();
	if (data.preventBackgroundScrolling) {
		setBodyBackgroundScrolling(false);
	}
	//preventExtendedASCIIcharacters("#commonDialogDiv")
}
function hideCommonDialog() {
	var style = $("body").attr("style");
	if (exists(style)) {
		$("body").attr("style", style.replace("height: 100vh;", ""));
	}
	$("#commonDialogDiv").html("");
}
function updateBlurPageMessage(message) {
	if ($("#mainmessage").is(":visible")) {
		$("#mainmessage").html(message);
	} else {
		blurPage(message);
	}
}
function blurPage(data, hideEllipsis, hideSpinner) {
	unblurPage();
	$("body").css("cursor", "progress");
	var modal = "<div id='blurModal' class='modal' data-visibility='hidden' role='dialog'><div id='spinnerContainer' style='text-align: center; color: white; font-size: 20px; background: rgba(0,0,0,.3);min-height: 60px;'><div style='position: relative;height: 60px;'><div style='margin: 0;position: absolute;top: 50%;left: 50%;transform: translate(-50%, -50%);'><span id='mainmessage' style='margin-left: 5px;'>Please wait</span><span class='etcetera' style='margin-left: 5px; font-size: 42px; line-height: 20px;'>...</span> <span class='fa fa-spinner fa-spin etcetera'></span></div></div></div></div>";
	$("#commonDialogDiv").html(modal);
	if (data) { $("#mainmessage").html(data); }
	if (hideEllipsis) {
		$(".etcetera").hide();
	}
	if (hideSpinner) {
		$("#spinnerContainer").hide();
	}
	$("#blurModal").show();
}
function unblurPage() {
	$("#commonDialogDiv").html("");
	$("body").css("cursor", "default");
}
function blurPreview(data, hideEllipsis) {
	unblurPreview();
	var modal = "<div id='blurPreviewModal' class='modal' data-visibility='hidden' role='dialog'><div style='text-align: center; color: white; font-size: 20px; background: rgba(0,0,0,.3);min-height: 60px;'><div style='position: relative;height: 60px;'><div style='margin: 0;position: absolute;top: 50%;left: 50%;transform: translate(-50%, -50%);'><span id='mainPreviewmessage' style='margin-left: 5px;'>Please wait</span><span class='etcetera' style='margin-left: 5px; font-size: 42px; line-height: 20px;'>...</span> <span class='fa fa-spinner fa-spin etcetera'></span></div></div></div></div>";
	$("#commonPreviewDialogDiv").html(modal);
	if (data) { $("#mainPreviewmessage").html(data); }
	if (hideEllipsis) {
		$(".etcetera").hide();
	}
	$("#blurPreviewModal").show();
}
function unblurPreview() {
	$("#commonPreviewDialogDiv").html("");
}
function deferredPageBlur(deferred, message) {
	if (!exists(deferred)) return;
	setInterval(function () {
		if (deferred.state() === "pending") {
			deferred.notify(isNullOrWhiteSpace(message) ? deferred.state() : message);
		}
		else {
			unblurPage();
		}
	}, 1);
}
function setBodyBackgroundScrolling(allowScrolling) {
	let vHeight = "height:100vh!important;overflow:hidden!important;";
	let style = removeAllWhiteSpaces(stringOrDefault($("body").attr("style")));
	if (allowScrolling) {
		$("body").attr("style", style.replace(vHeight, ""));
	} else {
		$("body").attr("style", string.format("{0}{1}", vHeight, style));
	}
}
function getQueryValueByName(name, url) {
	if (!url) url = window.location.href;
	var regex = new RegExp("[\\?&]" + name + "=([^&#]*)");
	var results = regex.exec(url);
	return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}
function getQueryStringByName(name, win, url) {
	if (!exists(win)) {
		win = window;
	}
	if (!url) url = win.location.href;
	var regex = new RegExp("[\\?&]" + name + "=([^&#]*)");
	var results = regex.exec(url);
	return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}
function queryString(key) {
	return getQueryValueByName(key);
}
function changeToLabel(innerSelectors, outerSelector) {
	$(innerSelectors, $(outerSelector)).each(function () {
		var control = $(this);
		control.replaceWith($("<span>").text(control.val()));
	});
}
function replaceControl(obj) {
	if (!exists(obj) || !exists(obj.id)) {
		return;
	}
	var controlId = getDomElementById(obj.id).attr("id");
	var control = $(obj.root).find(string.format("#{0}", controlId));
	var attr = obj.hasOwnProperty("attr") ? obj.attr : "";
	switch (obj.control) {
		case "input":
			control.replaceWith($(string.format("<input type='{0}' class='{1} padding-lr2' {2}/>", obj.type, obj.cssClass, attr)).val(valueOrText(controlId)).attr("id", controlId));
			break;
		case "select":
			control.replaceWith($(string.format("<select class='{0}' {1}>{2}</select>", obj.cssClass, attr, obj.options)).val(valueOrText(controlId)).attr("id", controlId));
			break;
		case "datetimepicker":
			var containerId = controlId + "__DateTimeContainer";
			var div = buildDateControl(containerId, controlId, valueOrText(controlId), obj.iconHolderClass, obj.inputClass, obj.dateFormat, attr);
			control.replaceWith(div);
			// Note: If this control is meant to be added within a table-cell, please make sure the cell positioning is set to 'relative' and overflow value set to 'visible'
			// without this the calendar modal might not show over the table.
			$("#" + div.id).datetimepicker({ format: obj.dateFormat });// , keepOpen: true, widgetParent: $("#" + div.id).closest("td"), debug: true
			break;
	}
}
function buildDateControl(containerId, inputId, defaultDate, iconHolderClass, inputClass, dateFormat = "MM/DD/YYYY", attr) {
	var iconHolder = document.createElement("span");
	iconHolder.setAttribute("class", "input-group-addon " + iconHolderClass);
	var icon = document.createElement("span");
	icon.setAttribute("class", "glyphicon glyphicon-calendar");
	iconHolder.appendChild(icon);

	var input = document.createElement("input");
	input.setAttribute("id", inputId);
	input.setAttribute("class", "form-control " + inputClass);
	input.setAttribute("type", "text");
	input.setAttribute("placeholder", dateFormat);
	if (!isNullOrWhiteSpace(attr)) {
		$.each(attr.split(";"), (_, attrPair) => {
			var array = attr.split("=");
			input.setAttribute(array[0], array[1]);
		});
	}
	input.value = defaultDate;

	var container = document.createElement("div");
	container.setAttribute("id", containerId);
	container.setAttribute("class", "input-group date");

	container.appendChild(input);
	container.appendChild(iconHolder);
	return container;// The picker control control is not yet activated until you use this returned element like: [$("#" + container.id).datetimepicker({ format: dateFormat });]
}
function intOrDefault(value) {
	//return isInt(value) ? value : isNumeric(value) ? parseInt(value, 10) : 0;
	return isNumeric(value) ? parseInt(value, 10) : 0;
}
function intOrNull(value) {
	//return isInt(value) ? value : isNumeric(value) ? parseInt(value, 10) : null;
	return isNumeric(value) ? parseInt(value, 10) : null;
}
function floatOrDefault(value) {
	if (!isNumeric(value)) return 0;// Number(0).toFixed(1);
	return parseFloat(value);
}
function stringOrDefault(value) {
	return !exists(value) || isFunction(value) ? "" : (value).toString().replaceAll("\"", "\'");
}
function stringOrNull(value) {
	return isNullOrWhiteSpace(value) ? null : value;
}
function emptyString(value) {
	return isEmpty(value) ? "" : value;
}
function emptyDate(value) {
	return isEmpty(value) ? null : value;
}
function emptyCurrency(value) {
	return isNullOrWhiteSpace(value) ? 0 : unformatCurrency((value).toString().toNumberOrDefault());
}
function emptyCurrencyReturnNull(value) {
	return isEmpty(value) || value.trim() === "$" ? null : unformatCurrency(value);
}
function nullInt(value) {
	return isNullOrWhiteSpace(value) ? undefined : (value).toString().toNumberOrDefault();
}
function setCurrVal(value, wholeNum) {
	if (value === null || value === "undefined" || value === undefined || value === "") {
		return null;//when null, zero, or empty string set data to null so bootstrap placeholder values are shown
	}
	else {
		if (!wholeNum) {
			return formatCurrency(value);
		} else {
			return formatCurrencyWholeNumber(value);
		}
	}
}
function isEmpty(value) {

	if (value === 0 || value === "0") {
		return false;
	}
	else if (value === undefined || value === null || value === "" || value === "undefined") {
		return true;
	}
	else {
		return false;
	}
}
function yesOrNoToBool(value) {
	return !exists(value) || isNullOrWhiteSpace(value) || value.toLowerCase() === "no" ? false : true;
}
function cleanCurrency(value) {
	if (isNullOrWhiteSpace(value)) return "0";
	value = value.replace(/[\$\,]/g, "");
	if (value.match(/^\({1}[\d,\.]*\){1}$/)) {
		value = "-" + value.replace(/[\(\),]/g, "");
	}
	if (value.indexOf(".") > -1) {
		return parseFloat(value);
	} else {
		return parseInt(value);
	}
}
function cleanNumber(value) {
	if (isNullOrWhiteSpace(value)) return string.empty;
	return value.replace(/[\$\,\n]/g, "");
}
function bytesToSize(bytes) {
	var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
	if (bytes === 0) return "0 Bytes";
	var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
	return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
}
function setCookie(cookieName, cookieValue, expirationDays, path = window.location.pathname) {
	if (cookieValue === undefined) return;
	let dbg = location.href.toLowerCase().contains("accurategroup.loc");
	expirationDays = isNullOrUndefined(expirationDays) ? 1 : expirationDays;
	path = isNullOrWhiteSpace(path) ? "" : path;
	var newEntry = String.format("{0}={1} {2}", cookieName, cookieValue, dbg ? "" : "; Secure; SameSite=Lax").trim();
	var date = new Date();
	date.setTime(date.getTime() + (expirationDays * 24 * 60 * 60 * 1000));
	var expires = "expires=" + date.toUTCString();
	document.cookie = String.format("{0};{1};path={2}", newEntry, expires, path);
	//setOrUpdateCookie(cookieName, cookieValue, expirationDays, path);//setOrUpdateCookie(name, value = "", day = -1, path = "/")
}
function getCookie(cookieName) {
	var name = cookieName + "=";
	var decodedCookie = decodeURIComponent(document.cookie);
	var ca = decodedCookie.split(";");
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) === " ") {
			c = c.substring(1);
		}
		if (c.indexOf(name) === 0) {
			return c.substring(name.length, c.length);
		}
	}
	return "";
}
function deleteCookie(cookieName) {
	document.cookie = String.format("{0}=;Path=/;expires={1}", cookieName, moment().add(-1, "years"));
}
function isMSBrowserFamily() {
	var userAgent = window.navigator.userAgent;
	var msie = userAgent.indexOf("MSIE ");
	if (msie > 0) {
		// IE 10 or older => return version number
		return parseInt(userAgent.substring(msie + 5, userAgent.indexOf(".", msie)), 10);
	}
	var trident = userAgent.indexOf("Trident/");
	if (trident > 0) {
		// IE 11 => return version number
		var rv = userAgent.indexOf("rv:");
		return parseInt(userAgent.substring(rv + 3, userAgent.indexOf(".", rv)), 10);
	}

	var edge = userAgent.indexOf("Edge/");
	if (edge > 0) {
		// Edge (IE 12+) => return version number
		return parseInt(userAgent.substring(edge + 5, userAgent.indexOf(".", edge)), 10);
	}

	// other browser
	return false;
}
function removeAllWhiteSpaces(str, newChar = "") {
	return str.replace(/\s/g, newChar);
};
function hasWhiteSpacesWithin(str) {
	return /\s/g.test(str.trim());
};
function getDomElementById(id, parentContext) {
	var element = $("#" + id, parentContext);
	//return element.length > 0 ? element : $("[id$=_" + id + "]", parentContext);
	return element.length > 0 ? element : $(string.format("[id$='{0}']", id), parentContext);
}
function getDomElementsById(ids) {
	ids = ids.split(",");
	var elements = [];
	$.each(ids, function (i, id) {
		var elt = $("#" + id);
		var element = elt.length > 0 ? elt : $("[id$=_" + id + "]");
		if (element.length > 0) {
			elements.push("#" + element.attr("id"));
		}
	});
	return $(elements.join(","));
}
function firstOrDefault(array, predicate) {
	var matches = array.where(predicate);
	if (matches.length > 0) {
		return matches[0];
	}
	return null;
}
function shallowClone(obj) {
	return $.extend({}, obj); // .clone(); // JSON.parse(JSON.stringify(obj)); // Object.assign({}, obj);
};
function deepClone(obj) {
	return $.extend(true, {}, obj); // .clone(true);
};
function scrollElementToView(element, target, duration = 1000, easing = "swing") {
	_winScrollPos = $(window).scrollTop();
	if (!target) {
		target = document.getElementsByTagName("body");
	}
	var elementOffset = $(element).offset();
	var targetOffset = $(target).offset();
	if (targetOffset && elementOffset) {
		$(element).animate({ scrollTop: $(element).scrollTop() + targetOffset.top - elementOffset.top }, { duration: "slow", easing: easing });
		$("html,body").animate({ scrollTop: elementOffset.top }, { duration: duration, easing: easing });
	}
}
function getMedian(values) {
	if (values.any(function (value) { return !exists(value) || isFunction(value) || typeof value === "string"; })) return NaN;
	values.sort(function (a, b) { return a - b; });
	return (values[Math.floor((values.length - 1) / 2)] + values[Math.ceil((values.length - 1) / 2)]) / 2;
}
function syncFieldsWith(newValue, elementListOrSelector) {
	if (Array.isArray(elementListOrSelector)) {
		$.each(elementListOrSelector, function () {
			$(this).val(newValue);
		});
	} else if (!isNullOrWhiteSpace(elementListOrSelector)) {
		getDomElementById(elementListOrSelector).val(newValue);
	}
}
function setValueOrText(selector, value) {
	var $element = $(selector);
	return $element.is("span") ? $element.text(value) : $element.val(value);
}
function setTextOrValue(selector, value) {
	return setValueOrText(selector, value);
}
function valueOrText(id, selectValue) {
	var element;
	if (isHtmlElement(id)) {
		element = $(id);
		if (element.is("input") || element.is("textarea")) {
			return element.val();
		}
		else if (element.is("select")) {
			return selectValue ? element.val() : $(string.format("#{0} option:selected", element.attr("id"))).text();//element.children("option:selected").text();
		}
		return element.text();
	} else {
		element = getDomElementById(id);
		if (element.is("input") || element.is("textarea")) {
			return element.val();
		}
		else if (element.is("select")) {
			return selectValue ? element.val() : $(string.format("#{0} option:selected", element.attr("id"))).text();//element.children("option:selected").text();
		}
		return element.text();
	}
}
function textOrValue(id, selectValue) {
	return valueOrText(id, selectValue);
}
function getSelectedOptionAttr(selectorId, attr) {
	return $("#" + getDomElementById(selectorId).attr("id") + " option:selected").data(attr);
}
function validateNumber(evt, ignoredList) {
	var canAdd = false;
	var charCode = evt.which ? evt.which : evt.keyCode;
	try {
		for (var prop in _keyCodes) {
			if (_keyCodes.hasOwnProperty(prop) && parseInt(_keyCodes[prop]) === charCode && !ignoredList.contains(prop)) {
				canAdd = true;
				break;
			}
		}
	} catch (e) {
		success = false;
	}
	var pasteCopyOrCut = evt.getModifierState("Control") && (evt.key === "v" || evt.code === "keyV" || evt.key === "c" || evt.code === "keyC" || evt.key === "x" || evt.code === "keyX" || evt.key === "a" || evt.code === "keyA");
	if (!canAdd && !pasteCopyOrCut) {
		evt.preventDefault();
	}
	_keyCodes.previousCode = evt.code || evt.key;
}
function imageExists(imageUrl) {
	if (isNullOrWhiteSpace(imageUrl)) {
		return false;
	}
	//var http = new XMLHttpRequest();
	//try {
	//	http.open("HEAD", imageUrl, false);
	//	http.setRequestHeader("Content-Type", "application/json; charset=utf-8");
	//	http.send();
	//} catch (e) {
	//	return false;
	//}
	//return http.status === 200;
	return true;
}
function toTitleCase(str) {
	if (isNullOrWhiteSpace(str)) {
		return "";
	}
	return str.replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
}
function preventKeys(selector, keys) {
	var onKeyPressed = function (event) {
		if (exists(keys) && (keys === event.keyCode || (Array.isArray(keys) && keys.contains(event.keyCode)))) {
			event.preventDefault();
		}
	};
	$(selector).off("keydown", onKeyPressed).on("keydown", onKeyPressed);
}
function preventExtendedASCIIcharacters(rootSelector) {
	var onPaste = function (event) {
		var hasAscii = false;
		var data = getClipboardData(event);
		for (var i = 0; i < data.length; i++) {
			var code = data.charCodeAt(i);
			let success =
				exists(_extendedASCII_0_To_31) && (_extendedASCII_0_To_31 === code || (Array.isArray(_extendedASCII_0_To_31) && _extendedASCII_0_To_31.contains(code))) ||
				exists(_extendedASCII_128_To_255) && (_extendedASCII_128_To_255 === code || (Array.isArray(_extendedASCII_128_To_255) && _extendedASCII_128_To_255.contains(code)));
			if (success) {
				hasAscii = true;
				break;
			}
		}
		if (hasAscii) {
			event.preventDefault();
			Notify(_extendedASCIIcharactersMessage, "bottom-right", "5000", "primary", "fa-exclamation", true);
		}
	};
	var elements = $(string.format("{0}  input[type='text'], {0} textarea", rootSelector));
	elements.off("paste", onPaste).on("paste", onPaste);
}
function getClipboardData(evt) {
	var clipboardData = "";
	try {
		clipboardData = evt.originalEvent.clipboardData.getData("text");//Chrome
	}
	catch (e) {
		clipboardData = window.clipboardData.getData("text");//IE
	}
	return clipboardData;
}
function enforcingDigitOnly(event) {
	switch (event.type) {
		case "paste":
			var clipboardData = getClipboardData(event);
			var data = $(event.target).data("exceptions");
			var exceptions = [];
			if (exists(data) && !isNullOrWhiteSpace(data)) {
				exceptions = data.split(",");
			}
			var isValidNumber = /^-?\d*\.?\d*$/.test(clipboardData) || exceptions.any(function (x) { return x.toLowerCase() === clipboardData.toLowerCase(); });//exceptions.contains(clipboardData);
			if (!isValidNumber) {
				event.preventDefault();
			}
			break;
	}
	if (/^-?\d*\.?\d*$/.test(event.target.value)) {
		event.target.oldValue = event.target.value;
		event.target.oldSelectionStart = event.target.selectionStart;
		event.target.oldSelectionEnd = event.target.selectionEnd;
	} else if (event.target.hasOwnProperty("oldValue")) {
		event.target.value = event.target.oldValue;
		event.target.setSelectionRange(event.target.oldSelectionStart, event.target.oldSelectionEnd);
	} else {
		event.target.value = string.empty;
	}
}
function enforceDigitOnly(exceptions) {
	_eventList.forEach(function (item) {
		$(".digitOnly").on(item, enforcingDigitOnly);
	});
}

function makeSelectize(elementId, targetId, sortField, placeholder, callback) {
	if (isNullOrWhiteSpace(sortField)) {
		sortField = "text";
	}
	var options = {
		create: true,
		sortField: sortField,
		placeholder: placeholder,
		onChange: function (data) {
			var id = this.$input[0].id;
			var selectize = getDomElementById(id).selectize()[0].selectize;
			if (isFunction(callback)) {
				callback(data, selectize, targetId);
			}
		}
	};
	var selectizeObject = null;
	try {
		var element = getDomElementById(elementId);
		element.removeClass("form-control").addClass("font-weight-n");
		var classes = element.attr("class");
		if (!isNullOrWhiteSpace(classes) && classes.contains("margin-t")) {
			classes = classes.replace(/margin-t\d{1}/g, "margin-t2");
			element.attr("class", classes);
		} else {
			element.addClass("margin-t2");
		}
		if (!isNullOrWhiteSpace(classes) && classes.contains("width")) {
			classes = classes.replace(/width-\d{1,3}/g, "width-100");
			element.attr("class", classes);
		} else {
			element.addClass("width-100p");
		}

		selectizeObject = element.selectize(options);
		selectizeObject.clear(false);
	} catch (e) {
		//
	}
	return selectizeObject;
};
function createSelectize(jQueryElement, options) {
	var selectizeObject = null;
	try {
		jQueryElement.removeClass("form-control").addClass("font-weight-n");
		var classes = jQueryElement.attr("class");
		if (!isNullOrWhiteSpace(classes) && classes.contains("margin-t")) {
			classes = classes.replace(/margin-t\d{1}/g, "margin-t2");
			jQueryElement.attr("class", classes);
		} else {
			jQueryElement.addClass("margin-t2");
		}
		if (!isNullOrWhiteSpace(classes) && classes.contains("width")) {
			classes = classes.replace(/width-\d{1,3}/g, "width-100");
			jQueryElement.attr("class", classes);
		} else {
			jQueryElement.addClass("width-100p");
		}
		selectizeObject = jQueryElement.selectize(options);
		selectizeObject.clear(true);
	} catch (e) {
		//
	}
	return getSelectizeControl(jQueryElement.attr("id"));
}
function createSelectizeWithDefault(id, options, defaultValue, marginTop = "margin-t2", width100p = "width-100p", events = null) {
	var selectizeObject = null;
	var jQueryElement = getDomElementById(id);
	try {
		jQueryElement.removeClass("form-control").addClass("font-weight-n");
		var classes = jQueryElement.attr("class");
		if (!isNullOrWhiteSpace(classes) && classes.contains("margin-t")) {
			classes = classes.replace(/margin-t\d{1}/g, "margin-t2");
			jQueryElement.attr("class", classes);
		} else if (!isNullOrWhiteSpace(marginTop)) {
			jQueryElement.addClass(marginTop);
		}
		if (!isNullOrWhiteSpace(classes) && classes.contains("width")) {
			classes = classes.replace(/width-\d{1,3}/g, "width-100");
			jQueryElement.attr("class", classes);
		} else if (!isNullOrWhiteSpace(width100p)) {
			jQueryElement.addClass(width100p);
		}
		if (events) {
			getObjectPropertyValuePairs(events).forEach(obj => {
				if (isFunction(obj.value)) {
					options[obj.name] = obj.value;
				}
			});
		}
		jQueryElement.selectize(options);
		selectizeObject = getSelectizeControl(id);
		selectizeObject.clear(true);
		if (Array.isArray(defaultValue)) {
			selectizeObject.addItems(defaultValue, true);
		} else {
			selectizeObject.setValue(defaultValue, true);
		}
	} catch (e) {
		//
	}
	return selectizeObject;
}
function getSelectizeControl(selectorId) {
	let element = getDomElementById(selectorId).selectize();
	return element && element[0] ? element[0].selectize : null;
}
function getSelectizeControlValue(selectorId) {
	let obj = getSelectizeControl(selectorId);
	return $.isEmptyObject(obj) ? string.empty : obj.getValue();
}
function isSelectizeMultiSelect(selectorId) {
	return Array.isArray(getSelectizeControlValue(selectorId));
}
function wrapElementWithFormTag(elementId) {
	if (!getDomElementById(elementId).parent().is("form")) {
		getDomElementById(elementId).wrap("<form>").parent().attr("autocomplete", "off").css("overflow", "hidden").css("margin", "auto");
	}
}
function hideAllModals() {
	$(".modal").modal("hide");
	$(".modal-backdrop").remove();
}
function loadHtmlTemplate(templateId, targetId, contentRootPrefixId) {
	const template = document.querySelector("#" + templateId);
	if (!exists(template)) return string.empty;
	const content = template.content;
	if (!exists(content)) return string.empty;
	const docFragment = content.cloneNode(true);
	const firstChildTagName = docFragment.firstElementChild.tagName;
	let docFragmentId = docFragment.querySelector(firstChildTagName).id;
	if (contentRootPrefixId) {
		docFragmentId = contentRootPrefixId + docFragmentId;
		docFragment.querySelector(firstChildTagName).id = docFragmentId;
	}
	//document.querySelector("#" + targetId).innerHTML = "";
	let targetIdSelector = document.querySelector("#" + targetId);
	if (targetIdSelector) {
		targetIdSelector.appendChild(docFragment);
	}
	//$("#" + targetId).html(docFragment);
	return docFragmentId;
}
function acreToSqFt(acreValue, decimalPoint) {
	var oneAcre = 43560; // 1 acre = 43560 SqFt
	var sqFtValue = floatOrDefault(stringOrDefault(acreValue)) * oneAcre;
	return decimalPoint ? sqFtValue.toFixed(decimalPoint) : sqFtValue;
}
function sqFtToAcre(sqFtValue, decimalPoint) {
	var oneAcre = 43560; // 1 acre = 43560 SqFt
	var acreValue = floatOrDefault(stringOrDefault(sqFtValue)) / oneAcre;
	return decimalPoint ? acreValue.toFixed(decimalPoint) : acreValue;
}
function getObjectPropertyValuePairs(obj, allowedList) {
	var nameValues = [];
	var index = 0;
	for (var prop in obj) {
		if (Object.prototype.hasOwnProperty.call(obj, prop)) {
			var value = obj[prop];
			if (isBoolean(value)) {
				value = booleanToYesNoOrDefault(value);
			}
			if (allowedList) {
				index = allowedList.indexOf(prop);
				if (index < 0) continue;
				nameValues.push({ index: index, name: prop, value: value });
			}
			else {
				nameValues.push({ index: index++, name: prop, value: value });
			}
		}
	}
	return nameValues.orderBy("index");
}
function getObjectOwnProperties(obj) {
	var nameValues = [];
	for (var prop in obj) {
		if (Object.prototype.hasOwnProperty.call(obj, prop)) {
			var value = obj[prop];
			if (isBoolean(value)) {
				value = booleanToYesNoOrDefault(value);
			}
			nameValues.push({ name: prop, value: value });
		}
	}
	return nameValues.orderBy("name");
}
function fuelWizardEvent(wizardId, eventName, callback) {
	if (!eventName) {
		//Other possible events are: "actionclicked.fu.wizard", "click.fu.wizard","mouseover.fu.wizard", "finished.fu.wizard" (see: ...\assets\js\fuelux\fuelux.3.17.2.js)
		eventName = "changed.fu.wizard";
	}
	var button = getDomElementById(wizardId);
	button.focus();
	//button.on(eventName, function (event, data) {
	//    if (isFunction(callback)) {
	//        //event.data = data; //button.wizard("selectedItem");// Same as data
	//        callback(event, data);
	//    }
	//});
	function execFuelWizardEvent(event, data) {
		if (isFunction(callback)) {
			callback(event, data);
		}
	}
	button.off(eventName, execFuelWizardEvent).on(eventName, execFuelWizardEvent);
}
function setButtonToggleLabels(obj) {
	// obj sample: { sourceId: "id1", targetId: "id2", cookieName: "name", width: "135", height: null, style: "btn-flat", onLabel: "On", offLabel: "Off", onIcon: "<i class= 'fa fa-floppy-o font-16' ></i>", offIcon: "<i class= 'fa fa-floppy-o font-16' ></i>", checked: toggleButtonOn, enabled: true, callback: function () { console.log("Button Toggled!"); } }
	if (!exists(obj)) return;
	function autoSaveChanged(event) {
		buttonToggleChanged(obj.sourceId, obj.targetId, obj.cookieName);
		if (isFunction(obj.callback)) {
			obj.callback(event);
		}
	}
	getDomElementById(obj.sourceId)
		.bootstrapToggle({
			width: obj.width,
			height: obj.height,
			style: obj.style,
			on: isNullOrWhiteSpace(obj.onIcon) ? obj.onLabel : obj.onIcon + obj.onLabel,
			off: isNullOrWhiteSpace(obj.offIcon) ? obj.offLabel : obj.offIcon + obj.offLabel
		})
		.bootstrapToggle(obj.checked ? "on" : "off")
		.bootstrapToggle(obj.enabled ? "enable" : "disable")
		.attr("type", "checkbox")
		.show()
		.off("change", autoSaveChanged).on("change", autoSaveChanged);
	//.change(function (event) {
	//	//event.preventDefault();
	//	//event.stopPropagation();
	//	buttonToggleChanged(obj.sourceId, obj.targetId, obj.cookieName);
	//	if (isFunction(obj.callback)) {
	//		obj.callback(event);
	//	}
	//      });
}
function buttonToggleChanged(sourceId, targetId, cookieName) {
	if (getDomElementById(sourceId).prop("checked")) {
		setCookie(cookieName, true, 1);
		setAutoSaveExecutionInterval(targetId);
		Notify("Auto Save Enabled.", "bottom-right", "2000", "info", "fa-info-circle", true);
	} else {
		setCookie(cookieName, false, 1);
		clearInterval(_autoSave);
		Notify("Auto Save Disabled.", "bottom-right", "2000", "info", "fa-info-circle", true);
	}
}
function addVerticalTabClickEvent(callback) {
	function execAddVerticalTabClickEvent(e) {
		e.preventDefault();
		$(this).addClass("active").siblings("a.active").removeClass("active");
		var position = $(this).index() + 1;
		var next = $(this).closest("div.verttab-tab-menu").next();
		next.find("div.verttab-tab-content").removeClass("active");
		next.find(string.format("div.verttab-tab-content:nth-child({0})", position)).addClass("active");
		if (isFunction(callback)) {
			callback(e);
		}
	}
	$("div.verttab-tab-menu>div.list-group>a").off("click", execAddVerticalTabClickEvent).on("click", execAddVerticalTabClickEvent);
}
function getRandomInt(max, min) {
	if (!exists(min)) {
		min = 0;
	}
	min = Math.ceil(min);
	max = Math.floor(max);
	// maximum is exclusive and the minimum is inclusive
	return Math.floor(Math.random() * (max - min) + min);
}
function getRandomAlpha(count) {
	if (!exists(count) || count <= 1) {
		count = 2;
	}
	var result = "";
	////var abc = ["A", "a", "B", "b", "C", "c", "D", "d", "E", "e", "F", "f", "G", "g", "H", "h", "I", "i", "J", "j", "K", "k", "L", "l", "M", "m", "N", "n", "O", "o", "P", "p", "Q", "q", "R", "r", "S", "s", "T", "t", "U", "u", "V", "v", "W", "w", "X", "x", "Y", "y", "Z", "z"];
	////var abc = [...[37713647386641440, 2196679683172530, 53605115].map(x => x.toString(36)).join``];
	//var abc = BigInt("8337503854730415241050377135811259267835").toString(36).split("");
	//var length = abc.length;
	//for (var i = 0; i < count; i++) {
	//	result += abc[getRandomInt(length)];
	//}
	var vowels = ["A", "E", "I", "O", "U", "Y"];
	var consonants = ["B", "C", "D", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "V", "W", "X", "Z"];
	for (var i = 0; i < count / 2; i++) {
		result += consonants[getRandomInt(consonants.length)];
		result += vowels[getRandomInt(vowels.length)];
	}
	return result.toProperCase();
}
function createDomElement(elementName, elementAttributes) {
	var element = document.createElement(elementName);
	$.each(elementAttributes, (_, obj) => {
		element.setAttribute(obj.attr, obj.attrValue);
	});
	return element;
}
function createTextBoxElement(defaultvalue, elementAttributes) {
	var input = document.createElement("input");
	if (elementAttributes && !elementAttributes.filter(x => x.attr === "type").any()) {
		input.setAttribute("type", "text");
	}
	$.each(elementAttributes, (_, obj) => {
		input.setAttribute(obj.attr, obj.attrValue);
	});
	input.defaultValue = defaultvalue;
	return input.outerHTML;
}
function createDateTimeElement(defaultvalue, elementAttributes) {
	var iconHolder = document.createElement("span");
	iconHolder.setAttribute("id", "calendarIcon");
	iconHolder.setAttribute("class", "input-group-addon dateTimecontainer-iconholder");
	iconHolder.setAttribute("onclick", "$(this).prev().select()");
	var icon = document.createElement("span");
	icon.setAttribute("class", "glyphicon glyphicon-calendar");
	iconHolder.appendChild(icon);
	var input = document.createElement("input");
	//input.setAttribute("class", "form-control height-34 datetimecontainer-input padding-lr1 z-index-0");
	input.setAttribute("type", "text");
	input.setAttribute("placeholder", "MM/DD/YYYY");
	$.each(elementAttributes, (_, obj) => {
		input.setAttribute(obj.attr, obj.attrValue);
	});
	input.defaultValue = defaultvalue;
	var container = document.createElement("div");
	container.setAttribute("class", "input-group date");
	container.appendChild(input);
	container.appendChild(iconHolder);
	return container.outerHTML;// The picker control control is not yet activated until you use this returned element like: [$("#" + container.id).datetimepicker({ format: dateFormat });]
}
function createSelectElement(options, defaultvalue, elementAttributes) {
	var select = document.createElement("select");
	$.each(elementAttributes, (_, obj) => {
		select.setAttribute(obj.attr, obj.attrValue);
	});
	$(select).append(options);
	$(select).val(defaultvalue);
	$(select).find(string.format("option[value='{0}']", defaultvalue)).attr("selected", "selected");
	return $(select).prop("outerHTML");
}
function setSelectElement(select, textValueOptions, defaultvalue) {
	select.innerHTML = "";
	let options = [document.createElement("option")];
	textValueOptions.forEach(x => {
		let option = document.createElement("option");
		option.value = x.value;
		option.innerHTML = x.value;
		options.push(option);
	});
	$(select).append(options);
	$(select).val(defaultvalue);
	$(select).find(string.format("option[value='{0}']", defaultvalue)).attr("selected", "selected");
}
function createUadValueDescElement(defaultvalue, elementAttributes) {
	var input = document.createElement("input");
	input.defaultValue = defaultvalue;
	input.setAttribute("type", "text");
	input.setAttribute("maxlength", "255");
	//input.setAttribute("data-prop-value", "");
	//input.setAttribute("data-prop-desc", "");
	input.setAttribute("readonly", "readonly");
	input.setAttribute("tabindex", "-1");
	input.setAttribute("placeholder", "Click to edit...");
	$.each(elementAttributes, (_, obj) => {
		input.setAttribute(obj.attr, obj.attrValue);
	});
	//
	var innerDiv = document.createElement("div");
	innerDiv.setAttribute("style", "display: flex; column-gap: 0.5em;");
	innerDiv.appendChild(input);
	//
	var outerDiv = document.createElement("div");
	outerDiv.setAttribute("class", "uadValueDescContainer");
	outerDiv.appendChild(innerDiv);

	return outerDiv.outerHTML;
}
function createUadDateOfSaleElement(defaultvalueUadFormat, elementAttributes) {
	var input = document.createElement("input");
	input.defaultValue = defaultvalueUadFormat;
	input.setAttribute("type", "text");
	input.setAttribute("readonly", "readonly");
	input.setAttribute("tabindex", "-1");
	input.setAttribute("placeholder", "Click to edit...");
	$.each(elementAttributes, (_, obj) => {
		input.setAttribute(obj.attr, obj.attrValue);
	});
	//
	var innerDiv = document.createElement("div");
	innerDiv.setAttribute("title", "Click to Add/Edit the date");
	innerDiv.setAttribute("style", "display: flex; column-gap: 0.5em;");
	innerDiv.setAttribute("data-toggle", "tooltip");
	innerDiv.setAttribute("data-html", "true");
	innerDiv.setAttribute("data-placement", "top");
	innerDiv.appendChild(input);
	//
	var outerDiv = document.createElement("div");
	outerDiv.setAttribute("class", "uadDateOfSaleContainer");
	outerDiv.appendChild(innerDiv);

	return outerDiv.outerHTML;
}
function isHtmlElement(obj) {
	try {
		return obj instanceof Element || obj instanceof HTMLDocument;
	}
	catch (e) {
		return (typeof obj === "object") && (obj.nodeType === 1) && (typeof obj.style === "object") && (typeof obj.ownerDocument === "object");
	}
}
function getFirstChildInnerText(parent) {
	if (!isHtmlElement(parent.firstChild)) {
		return parent.innerHTML;
	}
	return getFirstChildInnerText(parent.firstChild);
}
function isAlpha(value) {
	return value.length === 1 && value.match(/[a-z]/i);
}
function addOrUpdateUrlParam(name, value) {
	var url = new URL(location.href);
	url.searchParams.set(name, value);
	window.history.replaceState(null, document.title, url.href);
}
function moveControl(newParent, control) {
	$(newParent).append(control);
}
function scrollElementIntoView(domElement, options) {
	if (!domElement) {
		return;
	}
	if (!options) {
		options = { behavior: "smooth", block: "start" };
	}
	domElement.scrollIntoView(options);
	//if (intOrDefault(offsetValue) > 0) {
	//	var offset = $(domElement).offset();
	//	offset.top -= offsetValue;
	//}
}
function maskInput(selector, format, placeholder, autoclear = false) {
	return $(selector).mask(format, { placeholder: placeholder }, { autoclear: autoclear });
}
function getAge(yearBuilt) {
	return moment(moment().format("YYYY"), "YYYY").diff(moment(yearBuilt, "YYYY"), "years");
};
function validateMaxLength(event) {
	const { key } = event;
	let textSelected = isTextSelected();
	let maxlength = intOrDefault(event.target.getAttribute("maxlength"));
	let isDigit = isNumeric(key);
	var isPeriod = key === ".";
	let success = (isDigit || isPeriod) && !textSelected;
	if (success && maxlength > 0 && stringOrDefault(event.target.value).length + 1 > maxlength) {
		event.preventDefault();
		return false;
	}
}
function isTextSelected() {
	var selectedText = string.empty;
	if (window.getSelection) {
		selectedText = window.getSelection();
	} else if (document.getSelection) {
		selectedText = document.getSelection();
	} else if (document.selection) {
		selectedText = document.selection.createRange().text;
	}
	if (isNullOrWhiteSpace(selectedText)) {
		return false;
	}
	return selectedText && selectedText.type === "Range";
}
function getBase64DataPrefix(doctype, extension) {
	return string.format("data:{0}/{1};base64,", doctype, extension);
}
function generateGUID(upperCase = true) {
	var time = new Date().getTime();// moment.now();//
	return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (aChar) {
		var randomNumber = (time + Math.random() * 16) % 16 | 0;
		time = Math.floor(time / 16);
		let value = (aChar === "x" ? randomNumber : (randomNumber & 0x3 | 0x8)).toString(16);
		return upperCase ? value.toUpperCase() : value;
	});
}
function prefixWith(value, char, totalDigit) {
	if (isNullOrWhiteSpace(value)) {
		return string.empty;
	}
	return (value).toString().padStart(totalDigit, char);
}
function distinct(array, prop) {
	let list = prop ? array.map(item => item[prop]) : array.map(item => item);
	return list.filter((value, index, self) => self.indexOf(value) === index);
}
function checkExactMatch(text, pattern) {
	let success = false;
	if (hasWhiteSpacesWithin(pattern)) {
		//let regex = new RegExp(string.format("^{0}$", pattern), "gim");
		//var matches = text.match(regex);
		//success = stringToBoolean(matches && matches.any(function (x) { return pattern.toUpperCase() === x.toUpperCase(); }));
		success = text.toUpperCase().indexOf(pattern.toUpperCase()) > -1;
	} else {
		$.each(text.split(" "), (_, word) => {
			word = word.trim().replace(/[.,\/#!$%\^&\*;:{}=_`~()]/g, "");// Removed dashes: \-
			success = pattern.toUpperCase() === word.toUpperCase();
			if (success) {
				return false;
			}
		});
	}
	return success;
}
function replaceStart(text, pattern) {
	if (isNullOrWhiteSpace(text) || isNullOrWhiteSpace(pattern)) return string.empty;
	text = text.toString().trimStart();
	let regex = new RegExp(string.format("^{0}+", pattern), "gmi");
	return text.replace(regex, string.empty).trimStart();
}
function replaceEnd(text, pattern) {
	if (isNullOrWhiteSpace(text) || isNullOrWhiteSpace(pattern)) return string.empty;
	text = text.toString().trimEnd();
	let regex = new RegExp(string.format("{0}+$", pattern), "gmi");
	return text.replace(regex, string.empty).trimEnd();
}
function replaceBoth(text, pattern) {
	if (isNullOrWhiteSpace(text) || isNullOrWhiteSpace(pattern)) return string.empty;
	text = text.toString().trim();
	let regex = new RegExp(string.format("^{0}+|{0}+$", pattern), "gmi");
	return text.replace(regex, string.empty).trim();
}
function validateEmailAddress(oneOrMultipleEmails, separator = ";") {
	let valid = true;
	oneOrMultipleEmails = replaceBoth(oneOrMultipleEmails, separator);
	$.each(oneOrMultipleEmails.split(separator), (_, email) => {
		valid = regexEmail.test(email);
		if (!valid) {
			valid = false;
			return false;
		}
	});
	return valid;
}
function uuidv4() {
	return "10000000-1000-4000-8000-100000000000".replace(/[018]/g, c => (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
	);
}
function toLocaleDateTimeString(dateTime) {
	if (!dateTime) {
		dateTime = new Date();
	}
	return string.format("{0} {1}", dateTime.toLocaleDateString(), dateTime.toLocaleTimeString());
}
function typeaheadSubstringMatcher(strs) {
	return function findMatches(q, cb) {
		var matches, substringRegex;
		matches = [];
		var enteredChar = q;
		substrRegex = new RegExp(q, 'i');
		$.each(strs, function (i, str) {
			if (substrRegex.test(str)) {
				var tStr = str.toUpperCase();
				var tEChar = enteredChar.toUpperCase();
				if (tStr.startsWith(tEChar)) {
					matches.push(str);
				}
			}
		});
		cb(matches);
	};
};
function getSessionStorage(key) {
	if (exists(typeof window.Storage)) {
		return sessionStorage.getItem(key);
	}
	return string.empty;
}
function setSessionStorage(key, value) {
	if (exists(typeof window.Storage)) {
		sessionStorage.setItem(key, value);
	}
}
function getFileName(url) {
	if (isNullOrWhiteSpace(url)) { return string.empty; }
	return url.split('/').pop();
}
function getFileExtension(url) {
	if (isNullOrWhiteSpace(url)) { return string.empty; }
	const fileName = getFileName(url);
	const lastDotIndex = fileName.lastIndexOf(".");
	return lastDotIndex !== -1 ? fileName.slice(lastDotIndex + 1) : string.empty;
}
function hasEllipsis(element) {
	return element.offsetWidth < element.scrollWidth;
}
function momentDurationFormatCustomTemplate(format = "d [days] hh [hrs] mm [min] ss [sec]") {
	return format;
}
function applyKoBindings(viewModel, elementId, clean = true) {
	let element = document.getElementById(elementId);
	if (clean) {
		ko.cleanNode(element);
	}
	ko.applyBindings(viewModel, element);
}
function isControlVisible(selectorId) {
	var element = getDomElementById(selectorId);
	return exists(element) && element.is(":visible");
}
function isElementVisible(element, includeViewport = true) {
	if (!element) return false;
	const isInViewPort = isInViewport(element);
	const isVisible = element.checkVisibility({ checkOpacity: true, visibilityProperty: true, checkVisibilityCSS: true, contentVisibilityAuto: true });
	return includeViewport ? isInViewPort && isVisible : isVisible;
}
function isInViewport(element) {
	const rect = element.getBoundingClientRect();
	return (
		rect.top >= 0 &&
		rect.left >= 0 &&
		rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
		rect.right <= (window.innerWidth || document.documentElement.clientWidth)
	);
}
function resizeImage(event, defaultWidth = 450) {
	return new Promise(function (resolve, reject) {
		const file = event.target.files[0];
		if (!file || !file.type.startsWith('image/')) {
			console.error("Please select an image file.");
			return;
		}
		const reader = new FileReader();
		reader.readAsArrayBuffer(file); // Read as ArrayBuffer to access EXIF data
		reader.onload = function (evt) {
			const arrayBuffer = evt.target.result;
			const image = new Image();
			let orientation = 1; // Default orientation
			try {
				const dataView = new DataView(arrayBuffer);
				if (dataView.getUint16(0, false) === 0xFFD8) { // JPEG SOI
					let offset = 2;
					while (offset < dataView.byteLength) {
						if (dataView.getUint16(offset, false) === 0xFFE1) { // APP1 marker (EXIF)
							const exifSize = dataView.getUint16(offset + 2, false);
							const tiffOffset = offset + 8; // Offset to TIFF header
							const byteOrder = dataView.getUint16(tiffOffset, false);
							const isLittleEndian = byteOrder === 0x4949;
							// Get IFD0 offset
							const ifd0Offset = dataView.getUint32(tiffOffset + 4, isLittleEndian);
							// Read the number of entries in IFD0
							const numEntries = dataView.getUint16(tiffOffset + ifd0Offset, isLittleEndian);
							for (let i = 0; i < numEntries; i++) {
								const entryOffset = tiffOffset + ifd0Offset + 2 + (i * 12);
								const tag = dataView.getUint16(entryOffset, isLittleEndian);
								if (tag === 0x0112) { // Orientation tag
									orientation = dataView.getUint16(entryOffset + 8, isLittleEndian);
									break; // Found orientation, exit loop
								}
							}
							break; // Found EXIF data, exit loop
						}
						offset++; // Keep searching for APP1 marker
					}
				}
			}
			catch (error) {
				console.warn("Could not read EXIF orientation:", error);
			}
			image.src = URL.createObjectURL(new Blob([arrayBuffer], { type: file.type })); // Create Object URL for the image
			image.onload = function (e) {
				const canvas = document.createElement("canvas");
				const ctx = canvas.getContext("2d");

				let aspectRatio = defaultWidth / e.target.width;
				if (e.target.width > 1000) {
					defaultWidth = Math.floor(e.target.width / defaultWidth)*100;
					aspectRatio = defaultWidth / e.target.width;
				}

				// Apply rotation based on EXIF orientation
				if (orientation > 1) { // Rotate based on EXIF orientation if needed
					switch (orientation) {
						case 2:
							ctx.translate(e.target.width, 0);
							ctx.scale(-1, 1);
							break;
						case 3:
							ctx.translate(e.target.width, e.target.height);
							ctx.rotate(Math.PI);
							break;
						case 4:
							ctx.translate(0, e.target.height);
							ctx.scale(1, -1);
							break;
						case 5:
							ctx.rotate(0.5 * Math.PI); // Rotate 90 degrees clockwise
							ctx.scale(1, -1);
							[e.target.width, e.target.height] = [e.target.height, e.target.width]; // Swap width and height
							break;
						case 6:
							ctx.translate(e.target.width, 0);
							ctx.rotate(0.5 * Math.PI);
							[e.target.width, e.target.height] = [e.target.height, e.target.width]; // Swap width and height
							break;
						case 7:
							ctx.translate(e.target.width, 0);
							ctx.rotate(0.5 * Math.PI);
							ctx.scale(-1, 1);
							[e.target.width, e.target.height] = [e.target.height, e.target.width]; // Swap width and height
							break;
						case 8:
							ctx.translate(0, e.target.height);
							ctx.rotate(-0.5 * Math.PI);
							[e.target.width, e.target.height] = [e.target.height, e.target.width]; // Swap width and height
							break;
					}
				}

				//// Calculate new dimensions, maintaining aspect ratio
				//const aspectRatio = e.target.width / e.target.height;
				//let newImageWidth = defaultWidth;
				//let newImageHeight = defaultWidth / aspectRatio;
				//if (newImageHeight > height && newImageWidth > e.target.width) {
				//	newImageWidth = e.target.width;
				//	newImageHeight = e.target.height;
				//}
				//else if (newImageHeight > defaultWidth && aspectRatio < 1) {
				//	newImageHeight = defaultWidth;
				//	newImageWidth = defaultWidth * aspectRatio;
				//}
				//canvas.width = newImageWidth;
				//canvas.height = newImageHeight;
				//// Draw the image to the canvas
				//ctx.drawImage(this, 0, 0, e.target.width, e.target.height, 0, 0, newImageWidth, newImageHeight);

				
				canvas.width = defaultWidth;
				canvas.height = e.target.height * aspectRatio;
				// Draw the image to the canvas
				ctx.drawImage(e.target, 0, 0, canvas.width, canvas.height);
				// Export to JPEG with quality 90
				const dataURL = canvas.toDataURL('image/jpeg', 0.9);
				URL.revokeObjectURL(e.target.src);// releases the object URL that was previously created by calling URL.createObjectURL()
				resolve(dataURL);
			};
		};
		reader.onerror = reject;
	});	
}

// OBJECT
$.register(Object, "toKoObject", function (obj) {
	var retObj = {};
	if (typeof ko === "undefined") return retObj;
	for (var prop in obj) {
		if (Object.prototype.hasOwnProperty.call(obj, prop)) {
			var value = obj[prop];
			value = Array.isArray(value) ? ko.observableArray(value) : ko.observable(value);
			Object.defineProperty(retObj, prop, { value: value, writable: true, enumerable: true, configurable: true });
		}
	}
	return retObj;
});
$.register(Object, "asTuple", function (obj, type, ...args) {
	let tuple = {};
	$.each(args, (index, arg) => {
		tuple[string.format("item{0}", index + 1)] = arg;
	});
	if (isFunction(type)) {
		return $.isEmptyObject(tuple) ? new type(obj) : new type(obj, tuple);
	}
	return this;
});

//JQUERY
$.register($, "isNullOrUndefined", function (obj) {
	return obj === undefined || obj === null;
});
$.register($, "exists", function (obj) {
	return !$.isNullOrUndefined(obj);
});
$.register($, "getElementSelectorByClientId", function (id, context) {
	var element = $("#" + id, context);
	return "#" + element.length > 0 ? element.attr("id") : $("[id$=_" + id + "]", context).attr("id");
});
$.register($, "getElementByClientId", function (id, context) {
	var element = $("#" + id, context);
	return element.length > 0 ? element : $("[id$=_" + id + "]", context);
});
$.fnRegister($, "hasAttr", function (attributeName) {
	let success = false;
	try {
		let element = $(this)[0];
		success = element && element.hasAttribute(attributeName);
	}
	catch { }

	return success;
});
$.fnRegister($, "valueOrText", function (selectValue) {
	var element = $(this);
	if (element.is("input") || element.is("textarea")) {
		return element.val();
	}
	else if (element.is("select")) {
		return selectValue ? element.selectedOptionValue() : element.selectedOptionText();// element.children("option:selected").val() : element.children("option:selected").text(); // Note that for a select control we are bringing the option 'visible text' and not the option 'value'.
	}
	return element.text();
});
$.fnRegister($, "selectedOptionText", function () {
	var element = $(this);
	if (element.is("select")) {
		return element.children("option:selected").text();
	}
	return string.empty;
});
$.fnRegister($, "selectedOptionValue", function () {
	var element = $(this);
	if (element.is("select")) {
		return element.children("option:selected").val();
	}
	return string.empty;
});
$.register($, "ajaxJson", function (method, url, data, isAsync, callback) {
	return $.ajax({
		type: method,
		contentType: "application/json; charset=utf-8",
		url: url,
		dataType: 'json',
		callback: callback,
		data: data !== null ? JSON.stringify(data) : null,
		async: isAsync === false ? false : true
	})
		.fail(function (request, status, error) {
			if (request && !isNullOrWhiteSpace(request.responseText) && status === "error") {
				ShowError(error);
				console.log(request.responseText);
			}
		})
		.always(function (data) {
			if (isFunction(this.callback)) { this.callback(data); }
		});
});
$.register($, "postJson", function (url, data, isAsync, callmeback) {
	return $.ajaxJson("POST", url, data, isAsync, callmeback);
});
$.register($, "putJson", function (url, data, isAsync, callmeback) {
	return $.ajaxJson("PUT", url, data, isAsync, callmeback);
});
$.register($, "deleteJson", function (url, data, isAsync, callmeback) {
	return $.ajaxJson("DELETE", url, data, isAsync, callmeback);
});
$.register($, "getJsonResult", function (url, data) {
	var result = null;
	$.ajax(
		{
			type: "GET",
			contentType: "application/json; charset=utf-8",
			url: url,
			dataType: 'json',
			data: data !== null ? data : null,
			async: false
		}).done(function (r) { result = r; });
	return result;
});
$.register($, "getHeadersOnly", function (url) {
	return $.ajax({ type: "HEAD", url: url });
});
$.register($, "parseInitialValue", function (obj, propertyNames, defaultValue) {
	if (obj !== void 0 && obj !== null && typeof obj === 'object') {
		var list = Array.isArray(propertyNames) ? propertyNames : propertyNames.split(',');
		for (var i = 0; i < list.length; i++) {
			var property = list[i].getProperty(obj);
			if (!isNullOrUndefined(property)) {
				var value = obj[property];
				if (!exists(value) && Array.isArray(defaultValue)) {
					return defaultValue;
				}
				else if (value !== void 0 && value !== null) {
					if (isFunction(value)) {
						return value;
					}
					else {
						if (typeof value === "string" && typeof defaultValue === "boolean") {
							return value.toBoolean();
						}
						return value;
					}
				}
				break;
			}
		}
	}
	return (isFunction(defaultValue)) ? defaultValue() : defaultValue;
});
$.fnRegister($, "isVisible", function () {
	return $(this).is(":visible") || $(this).css("display") !== "none" || !$(this).hasClass("hide");
});

//ARRAY PROTOTYPE
$.register(Array.prototype, "cast", function (type, args) {
	var params = arguments[1];
	if (isFunction(type)) {
		return this.select(function (item) {
			return exists(params) ? new type(item, params) : new type(item);
		});
	}
	return this;
});
$.register(Array.prototype, "asTuple", function (type, ...args) {
	let tuple = {};
	$.each(args, (index, arg) => {
		tuple[string.format("item{0}", index + 1)] = arg;
	});
	if (isFunction(type)) {
		return this.select(function (item) {
			return $.isEmptyObject(tuple) ? new type(item) : new type(item, tuple);
		});
	}
	return this;
});
$.register(Array.prototype, "contains", function (value) {
	var count = this.length;
	if (count > 0) {
		for (var i = 0; i < count; i++) {
			var item = this[i];
			if (item === value) {
				return true;
			}
		}
	}
	return this.any(function (i) { return i === value; });
});
$.register(Array.prototype, "firstOrDefault", function (predicate) {
	var matches = this.where(predicate);
	if (matches.length > 0) {
		return matches[0];
	}
	return null;
});
$.register(Array.prototype, "lastOrDefault", function (predicate) {
	var matches = this.where(predicate);
	if (matches.length > 0) {
		return matches[matches.length - 1];
	}
	return null;
});
$.register(Array.prototype, "where", function (predicate) {
	if (isFunction(predicate)) {
		return $.grep(this, predicate);
	}
	return this;
});
$.register(Array.prototype, "any", function (predicate) {
	if (!exists(predicate)) {
		return this.length > 0;
	}
	return this.where(predicate).length > 0;
});
$.register(Array.prototype, "remove", function (value) {
	for (var i = 0; i < this.length; i++) {
		if (this[i] === value) {
			this.splice(i, 1);
			i--;
		}
	}
	return this;
});
$.register(Array.prototype, "removeAt", function (index) {
	if (this.length > index) {
		this.splice(index, 1);
	}
	return this;
});
$.register(Array.prototype, "select", function (selector) {
	return $.map(this, selector);
});
$.register(Array.prototype, "sum", function () {
	var total = 0;
	this.forEach(function (item) {
		var value = parseFloat(item);
		if (!isNaN(value)) {
			total += value;
		}
	});
	return total;
});
$.register(Array.prototype, "max", function (selector) {
	return Math.max.apply(this, isFunction(selector) ? this.select(selector) : this);
});
$.register(Array.prototype, "min", function (selector) {
	return Math.min.apply(this, isFunction(selector) ? this.select(selector) : this);
});
$.register(Array.prototype, "add", function (item) {
	if (item !== null && item !== undefined) {
		this.push(item);
	}
	return this;
});
$.register(Array.prototype, "insert", function (index, item) {
	if (item !== null && item !== undefined) {
		this.splice(index, 0, item);
	}
	return this;
});
$.register(Array.prototype, "insertRange", function (index, items) {
	var array = this;
	if (Array.isArray(items)) {
		items.reverse().forEach(function (item) {
			array.splice(index, 0, item);
		});
	}
	return this;
});
$.register(Array.prototype, "sortInt", function () {
	return this.sort(function (a, b) { return a - b; });
});
$.register(Array.prototype, "sortIntDesc", function () {
	return this.sort(function (a, b) { return b - a; });
});
$.register(Array.prototype, "orderBy", function (propertyNames) {
	if (!String.isNullOrWhiteSpace(propertyNames)) {
		return this.sort(function (obj1, obj2) {
			if ($.exists(obj1) && $.exists(obj2)) {
				var propertyNameArray = propertyNames.split(",");
				for (var i = 0; i < propertyNameArray.length; i++) {
					var propertyName = propertyNameArray[i];
					var v1 = obj1[propertyName];
					var v2 = obj2[propertyName];
					if (v1 !== undefined && v2 !== undefined) {
						if (v1 > v2) { return 1; }
						else if (v1 < v2) { return -1; }
					}
				}
			}
			return 0;
		});
	}
	return this;
});
$.register(Array.prototype, "distinct", function (prop) {
	let list = prop ? this.map(item => item[prop]) : this.map(item => item);
	return list.filter((value, index, self) => self.indexOf(value) === index);
});
$.register(Array.prototype, "groupBy", function (propertyName) {
	var array = [];
	this.forEach((value) => {
		var key = value[propertyName];
		var first = array.firstOrDefault(function (x) { return x.hasOwnProperty(key); });
		if (first) {
			first[key].push(value);
		} else {
			array.push({ [key]: [value] });
		}
	});
	return array;
});
$.register(Array.prototype, "orderByDescending", function (propertyNames) {
	if (String.hasContent(propertyNames)) {
		return this.orderBy(propertyNames).reverse();
	}
	return this;
});
$.register(Array.prototype, "orderByDate", function (propertyNames) {
	if (String.hasContent(propertyNames)) {
		return this.sort(function (obj1, obj2) {
			if ($.exists(obj1) && $.exists(obj2)) {
				var propertyNameArray = propertyNames.split(",");
				for (var i = 0; i < propertyNameArray.length; i++) {
					var propertyName = propertyNameArray[i];
					var v1 = moment(obj1[propertyName], "MM/DD/YYYY HH:mm");
					var v2 = moment(obj2[propertyName], "MM/DD/YYYY HH:mm");
					if ($.exists(v1) && $.exists(v2)) {
						if (v1.isSameOrBefore(v2)) { return 1; }
						else if (v1.isSameOrAfter(v2)) { return -1; }
					}
				}
			}
			return 0;
		});
	}
	return this;
});
$.register(Array.prototype, "orderByDateTime", function (propertyName, format) {
	if (String.hasContent(propertyName)) {
		return String.hasContent(format) ?
			this.sort(function (obj1, obj2) {
				return moment(obj1[propertyName], format).format(format) - moment(obj2[propertyName], format).format(format);
			}) :
			this.sort(function (obj1, obj2) {
				return moment(obj1[propertyName]) - moment(obj2[propertyName]);
			});
	}
	return this;
});
$.register(Array.prototype, "orderByDateDescending", function (propertyNames) {
	if (String.hasContent(propertyNames)) {
		return this.orderByDate(propertyNames).reverse();
	}
	return this;
});
$.register(Array.prototype, "orderByDateTimeDescending", function (propertyName, format) {
	return this.orderByDateTime(propertyName, format).reverse();
});
$.register(Array.prototype, "clone", function () {
	return $.extend([], this);
});
$.register(Array.prototype, "take", function (num) {
	var list = [];
	for (var i = 0; i < num; i++) {
		if (this.length >= i) {
			list.add(this[i]);
		}
	}
	return list;
});
$.register(Array.prototype, "skip", function (num) {
	var list = [];
	for (var i = num; i < this.length; i++) {
		if (this.length >= i) {
			list.add(this[i]);
		}
	}
	return list;
});
$.register(Array.prototype, "swap", function (index1, index2) {
	var temp = this[index1];
	this[index1] = this[index2];
	this[index2] = temp;
});
$.register(Array.prototype, "intersectionObserverAll", function (callback, options = { root: null, rootMargin: "0px", threshold: 1.0 }) {
	const observer = new IntersectionObserver((entries, observer) => {
		entries.forEach(entry => {
			// entry.boundingClientRect
			// entry.intersectionRatio
			// entry.intersectionRect
			// entry.isIntersecting
			// entry.rootBounds
			// entry.target
			// entry.time
			if (!entry.isIntersecting) {
				return;
			} else {
				if (isFunction(callback)) {
					callback(observer, entry.target);
				} else {
					const src = entry.target.dataset.src;
					if (src) {
						entry.target.src = src;
						entry.target.removeAttribute("data-src");
						observer.unobserve(entry.target);
					}
				}
			}
		});
	}, options);
	this.forEach(element => {
		observer.observe(element);
	});
});
$.register(Array.prototype, "resizeObserverAll", function (callback) {
	const observer = new ResizeObserver((entries) => {
		entries.forEach(entry => {
			if (isFunction(callback)) {
				//Just a test: entry.target.style.borderRadius = Math.max(0, 250 - entry.contentRect.width) + 'px';
				callback(entry.target);
			}
		});
	});
	//// Observe the scrollingElement for when the window gets resized
	//observer.observe(document.scrollingElement);
	this.forEach(element => {
		observer.observe(element);
	});
});
$.register(Array.prototype, "mutationObserverAll", function (callback, options = { childList: true, attributes: true, attributeOldValue: true, attributeFilter: [], subtree: true, characterData: true, characterOldValue: true }) {
	const observer = new MutationObserver((entries, observer) => {
		entries.forEach(entry => {
			if (isFunction(callback)) {
				callback(observer, entry.target);
			}
		});
	});
	this.forEach(child => {
		observer.observe(child, options);
	});
});
$.register(Array.prototype, "flatten", function () {
	return this.flat(Infinity);
});

//STRING PROTOTYPE
$.register(String.prototype, "escapeRegex", function () {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
}, true);
$.register(String.prototype, "contains", function (value, ignoreCase) {
	if (!exists(value) || typeof this.toString() !== "string") return string.empty;
	return new RegExp(value.escapeRegex(), ignoreCase === true ? "i" : "").test(this.toString());
}, true);
$.register(String.prototype, "remove", function (value) {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replaceAll(value, "");
});
$.register(String.prototype, "removeLast", function (count) {
	if (typeof this.toString() !== "string") return string.empty;
	if (this.toString().length >= count) {
		return this.toString().substr(0, this.toString().length - count);
	}
	return this.toString();
});
$.register(String.prototype, "toBoolean", function () {
	if (typeof this.toString() !== "string") return string.empty;
	var value;
	try {
		value = this.toString().toLowerCase().trim();
	} catch (e) {
		value = null;
	}
	if (!value) return false;
	switch (value) {
		case "true": case "yes": case "1": return true;
		case "false": case "no": case "0": return false;
		default: return true;
	}
});
$.register(String.prototype, "firstChar", function (count) {
	if (typeof this.toString() !== "string") return string.empty;
	if (this.toString().length > count) {
		return this.toString().substr(0, count);
	}
	return this.toString();
});
$.register(String.prototype, "lastChar", function (count) {
	if (typeof this.toString() !== "string") return string.empty;
	if (this.toString().length >= count) {
		return this.toString().substr(this.toString().length - count, count);
	}
	return this.toString();
});
$.register(String.prototype, "isNumber", function () {
	if (typeof this.toString() !== "string") return string.empty;
	var value = this.toString().toString();
	return String.isNullOrWhiteSpace(value) ? false : !isNaN(new Number(value));
});
$.register(String.prototype, "isAlpha", function () {
	return this.length === 1 && this.match(/[a-z]/i);
});
$.register(String.prototype, "toWords", function () {
	if (typeof this.toString() !== "string") return string.empty;
	var words = [];
	for (var i = 0; i < this.toString().length; i++) {
		var char = this.toString().charAt(i);
		if (words.length > 0 && String.isUpperCase(char) && String.isLowerCase(this.toString().charAt(i - 1))) {
			words.push(" ");
		}
		words.push(char);
	}
	return words.join("");
});
$.register(String.prototype, "toProperCase", function () {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replace(/\w\S*/g, function (txt) { return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase(); });
});
$.register(String.prototype, "toJsonPropertyName", function () {
	if (typeof this.toString() !== "string") return string.empty;
	if (!String.isNullOrWhiteSpace(this.toString()) || !String.isLowerCase(this.toString())) {
		return (this.toString().charAt(0).toLowerCase() + this.toString().substr(1, this.toString().length - 1)).split(' ').join('');
	}
	return this.toString();
});
$.register(String.prototype, "toDigitOnly", function () {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replace(/\D/gmi, "");
});
$.register(String.prototype, "toCharacterOnly", function () {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replace(/\d/gmi, "");
});
$.register(String.prototype, "toAlphaOnly", function () {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().replace(/[\W_]+/gmi, "");
});
$.register(String.prototype, "replaceAll", function (value1, value2) {
	var regex = new RegExp(value1, "gmi");
	return this.toString().replace(regex, value2);
});
$.register(String.prototype, "replaceValue", function (pattern, scope, newValue) {
	if (typeof this.toString() !== "string") return string.empty;
	return this.toString().toString().replace(this.toString().match(new RegExp(pattern, scope)), newValue);
});
$.register(String.prototype, "floatOrDefault", function () {
	if (typeof this.toString() !== "string") return string.empty;
	var value = exists(this.toString()) ? this.toString().toString() : "0";
	if (!isNumeric(value)) return 0;
	return parseFloat(value);
});
$.register(String.prototype, "intOrDefault", function () {
	if (typeof this.toString() !== "string") return string.empty;
	var value = exists(this.toString()) ? this.toString().toString() : "0";
	if (!isNumeric(value)) return 0;
	return parseInt(value);
});
$.register(String.prototype, "toNumberOrDefault", function (allowEmptyValue) {
	if (typeof this.toString() !== "string") return string.empty;
	if (!exists(allowEmptyValue)) {
		allowEmptyValue = true;
	}
	if (allowEmptyValue && isNullOrWhiteSpace(this.toString().toString())) {
		return undefined;
	}
	var value = cleanCurrency(this.toString().toString());
	return isNaN(value) ? 0 : parseInt(new Number(exists(value) ? (value).toString() : ""));
});
$.register(String.prototype, "toDecimalOrDefault", function (allowEmptyValue) {
	if (typeof this.toString() !== "string") return string.empty;
	if (!exists(allowEmptyValue)) {
		allowEmptyValue = true;
	}
	if (allowEmptyValue && isNullOrWhiteSpace(this.toString().toString())) {
		return undefined;
	}
	var value = cleanCurrency(this.toString().toString());
	return isNaN(value) ? 0 : parseFloat(new Number(exists(value) ? (value).toString() : ""));
});
$.register(String.prototype, "formatMoney", function (decimalPoint, preserveCurrencySign, allowEmptyValue) {
	if (typeof this.toString() !== "string") return string.empty;
	if (!exists(allowEmptyValue)) {
		allowEmptyValue = true;
	}
	if (allowEmptyValue && isNullOrWhiteSpace(this.toString().toString())) {
		return undefined;
	}
	var cleaned = cleanCurrency(this.toString().toString()).toString();
	if ((allowEmptyValue && isNullOrWhiteSpace(cleaned)) || (allowEmptyValue && isNaN(cleaned))) {
		return undefined;
	}
	var value = cleaned.toNumberOrDefault().toFixed(decimalPoint);
	return isNaN(value) ? "" : (preserveCurrencySign ? "$" + value.toNumberWithCommas() : value.toNumberWithCommas());
});
$.register(String.prototype, "formatDecimalMoney", function (decimalPoint, preserveCurrencySign, allowEmptyValue) {
	if (typeof this.toString() !== "string") return string.empty;
	if (!exists(allowEmptyValue)) {
		allowEmptyValue = true;
	}
	if (allowEmptyValue && isNullOrWhiteSpace(this.toString().toString())) {
		return undefined;
	}
	var cleaned = cleanCurrency(this.toString().toString()).toString();
	if ((allowEmptyValue && isNullOrWhiteSpace(cleaned)) || (allowEmptyValue && isNaN(cleaned))) {
		return undefined;
	}
	var value = cleaned.toDecimalOrDefault().toFixed(decimalPoint);
	return isNaN(value) ? "" : (preserveCurrencySign ? "$" + value.toNumberWithCommas() : value.toNumberWithCommas());
});
$.register(String.prototype, "toNumberWithCommas", function (allowEmptyValue) {
	if (typeof this.toString() !== "string") return string.empty;
	if (!exists(allowEmptyValue)) {
		allowEmptyValue = true;
	}
	if (allowEmptyValue && isNullOrWhiteSpace(this.toString().toString())) {
		return undefined;
	}
	var value = cleanCurrency(this.toString().toString());
	return (value).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
});
$.register(String.prototype, "getProperty", function (obj) {
	if (typeof this.toString() !== "string") return string.empty;
	var propertyName = this.toString().toString();
	if (exists(obj) && typeof obj === 'object' && !isNullOrWhiteSpace(propertyName)) {
		for (var p in obj) {
			if (obj.hasOwnProperty(p) && p.toLowerCase().trim() === propertyName.toLowerCase().trim()) {
				return p;
			}
		}
	}
	return null;
});
$.register(String.prototype, "escapeHtml", function () {
	if (typeof this.toString() !== "string") return string.empty;
	// Add more as needed...
	return this.toString().replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/'/g, "&rsquo;").replace(/"/g, "&quot;");
});
$.register(String.prototype, "hasContent", function () {
	return !String.isNullOrWhiteSpace(this + "");
});
$.register(String.prototype, "first", function (num = 1) {
	if (num <= 0) return this.toString();
	return this.length >= num ? this.substr(0, num) : this.toString();
});
$.register(String.prototype, "last", function (num = 1) {
	if (num <= 0) return this.toString();
	return this.length >= num ? this.substr(this.length - num) : this.toString();
});

//STRING
$.register(String, "format", function (format, args) {
	var value = format;
	for (var i = 1; i < arguments.length; i++) {
		var replace = "{" + (i - 1) + "}";
		var item = exists(arguments[i]) ? arguments[i] : "";
		if (!isNullOrWhiteSpace(value) && value.contains(replace)) {
			value = value.split(replace).join(item);
		}
	}
	return value;
});
$.register(String, "isNullOrWhiteSpace", function (value) {
	return value === null || value === undefined || typeof value !== "string" || value.trim().length === 0;
});
$.register(String, "isNumeric", function (value) {
	return $.isNumeric(value);
});
$.register(String, "intOrDefault", function (value) {
	return isNaN(value) ? 0 : parseInt("0" + value);
});
$.register(String, "floatOrDefault", function (value) {
	return isNaN(value) ? 0 : parseFloat("0" + value);
});
$.register(String, "hasContent", function (value) {
	return !String.isNullOrWhiteSpace(value);
});
$.register(String, "escapeHtml", function (value) {
	return (value + "")
		.replace(/&/g, "&amp;")
		.replace(/</g, "&lt;")
		.replace(/>/g, "&gt;")
		.replace(/"/g, "&quot;");
});
$.register(String, "isLowerCase", function (value) {
	return !String.isNullOrWhiteSpace(value) && !String.isNumeric(value) && value === value.toLowerCase();
});
$.register(String, "isUpperCase", function (value) {
	return !String.isNullOrWhiteSpace(value) && !String.isNumeric(value) && value === value.toUpperCase();
});
$.register(String, "defZero", function (value) {
	return String.isNullOrWhiteSpace(value) ? "0" : value;
});

// KO
if (typeof ko !== "undefined") {
	$.register(Array.prototype, "koGroupBy", function (propertyName) {
		var array = [];
		this.forEach((value) => {
			var key = value[propertyName];
			var first = array.firstOrDefault(function (x) { return x.hasOwnProperty(key); });
			if (first) {
				first[key]().push(value);
			} else {
				array.push({ [key]: ko.observable([value]) });
			}
		});
		return array;
	});
	$.register(ko.utils, "parseInitialValue", function (obj, propertyNames, defaultValue) {
		if (obj !== void 0 && obj !== null && typeof obj === 'object') {
			var list = Array.isArray(propertyNames) ? propertyNames : propertyNames.split(',');
			for (var i = 0; i < list.length; i++) {
				var property = list[i].getProperty(obj);
				if (property !== null) {
					var value = obj[property];
					if (value !== void 0 && value !== null) {
						if (isFunction(value)) {
							if (ko.isObservable(value)) {
								return value();
							}
							return value;
						}
						else {
							if (typeof value === 'string' && typeof defaultValue === 'boolean') {
								return value.toBoolean();
							}
							return value;
						}
					}
					break;
				}
			}
		}
		return (isFunction(defaultValue)) ? defaultValue() : defaultValue;
	});
	ko.bindingHandlers.readonlydate = {
		init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
			ko.bindingHandlers.enableDisable.update(element, valueAccessor);
		},
		update: function (element, valueAccessor) {
			var enabledDates = valueAccessor()();
			$(element).data("DateTimePicker").enabledDates(enabledDates);
		}
	};
	ko.bindingHandlers.datetimepicker = {
		init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
			let $self = $(element);
			//let options = allBindingsAccessor.has("options") ? allBindingsAccessor.get("options") : { format: _dateFormat };
			let format = $self.attr("data-format");
			let options = {
				showClear: true,
				format: isNullOrWhiteSpace(format) ? "MM/DD/YYYY" : format,
				widgetPositioning: { horizontal: "auto", vertical: "bottom" }
			};
			$self.closest(".input-group").datetimepicker(options)
				.on('dp.change', function (event) {
					let valAccessor = valueAccessor();
					if (ko.isObservable(valAccessor)) {
						valAccessor(event.date ? event.date.format(options.format) : "");
					}
				});
			try {
				let valAccessor = valueAccessor();
				let date = valAccessor();
				let usedFormat = isNullOrWhiteSpace(date) ? "" : moment(date).creationData().format;
				date = isNullOrWhiteSpace(date) ? "" : moment(date, usedFormat).format(options.format);
				valAccessor(date);
				$self.val(date);
			} catch { }
		},
		update: function (element, valueAccessor) {
			let widget = $(element).data("datepicker");
			if (widget) {
				widget.date = ko.utils.unwrapObservable(valueAccessor());
				if (widget.date) {
					widget.setValue();
				}
			}
		}
	};
	let injectBinding = function (allBindings, key, value) {
		return {
			has: function (bindingKey) {
				return (bindingKey == key) || allBindings.has(bindingKey);
			},
			get: function (bindingKey) {
				var binding = allBindings.get(bindingKey);
				if (bindingKey == key) {
					binding = binding ? [].concat(binding, value) : value;
				}
				return binding;
			}
		};
	};
	ko.bindingHandlers.selectize = {
		init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
			if (!allBindingsAccessor.has('optionsText')) {
				allBindingsAccessor = injectBinding(allBindingsAccessor, 'optionsText', 'name');
			}
			if (!allBindingsAccessor.has('optionsValue')) {
				allBindingsAccessor = injectBinding(allBindingsAccessor, 'optionsValue', 'id');
			}
			if (typeof allBindingsAccessor.get('optionsCaption') == 'undefined') {
				allBindingsAccessor = injectBinding(allBindingsAccessor, 'optionsCaption', 'Choose...');
			}
			ko.bindingHandlers.options.update(element, valueAccessor, allBindingsAccessor, viewModel, bindingContext);
			var options = {
				valueField: allBindingsAccessor.get('optionsValue'),
				labelField: allBindingsAccessor.get('optionsText'),
				searchField: allBindingsAccessor.get('optionsText')
			};
			if (allBindingsAccessor.has('options')) {
				var passed_options = allBindingsAccessor.get('options');
				for (var attr_name in passed_options) {
					options[attr_name] = passed_options[attr_name];
				}
			}
			var $select = $(element).selectize(options)[0].selectize;
			if (typeof allBindingsAccessor.get('value') == 'function') {
				$select.addItem(allBindingsAccessor.get('value')());
				allBindingsAccessor.get('value').subscribe(function (new_val) {
					$select.addItem(new_val);
				});
			}
			if (typeof allBindingsAccessor.get('selectedOptions') == 'function') {
				allBindingsAccessor.get('selectedOptions').subscribe(function (new_val) {
					// Removing items which are not in new value
					var values = $select.getValue();
					var items_to_remove = [];
					for (var k in values) {
						if (new_val.indexOf(values[k]) == -1) {
							items_to_remove.push(values[k]);
						}
					}
					for (var k in items_to_remove) {
						$select.removeItem(items_to_remove[k]);
					}
					for (var k in new_val) {
						$select.addItem(new_val[k]);
					}
				});
				var selected = allBindingsAccessor.get('selectedOptions')();
				for (var k in selected) {
					$select.addItem(selected[k]);
				}
			}
			if (typeof init_selectize == 'function') {
				init_selectize($select);
			}
			if (typeof valueAccessor().subscribe == 'function') {
				valueAccessor().subscribe(function (changes) {
					// To avoid having duplicate keys, all delete operations will go first
					var addedItems = new Array();
					changes.forEach(function (change) {
						switch (change.status) {
							case 'added':
								addedItems.push(change.value);
								break;
							case 'deleted':
								var itemId = change.value[options.valueField];
								if (itemId != null) $select.removeOption(itemId);
						}
					});
					addedItems.forEach(function (item) {
						$select.addOption(item);
					});

				}, null, "arrayChange");
			}
		},
		update: function (element, valueAccessor, allBindingsAccessor) {
			if (allBindingsAccessor.has('object')) {
				var optionsValue = allBindingsAccessor.get('optionsValue') || 'id';
				var value_accessor = valueAccessor();
				var selected_obj = $.grep(value_accessor(), function (i) {
					if (typeof i[optionsValue] == 'function')
						var id = i[optionsValue];
					else
						var id = i[optionsValue];
					return id == allBindingsAccessor.get('value')();
				})[0];
				if (selected_obj) {
					allBindingsAccessor.get('object')(selected_obj);
				}
			}
		}
	};
	ko.bindingHandlers.customcanvas = {
		init: function (canvas, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
			var ctx = canvas.getContext("2d");
			var img = new Image();
			img.crossOrigin = "anonymous";// for debugging and to visualize the image, comment out this line
			img.onload = function () {
				canvas.width = img.width;
				canvas.height = img.height;
				ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
				ctx.restore();
			};
			var src = valueAccessor()();// viewModel.fileSource()
			img.src = src;
		}
		//,update: function (element, valueAccessor) {
		//    var src = valueAccessor()();
		//}
	};
}
